/*
 * Decompiled with CFR 0.152.
 */
package leap.web.security;

import java.util.Map;
import leap.core.security.crypto.PasswordEncoder;
import leap.core.web.RequestIgnore;
import leap.web.security.SecurityFailureHandler;
import leap.web.security.SecurityInterceptor;
import leap.web.security.csrf.CsrfStore;
import leap.web.security.path.SecuredPaths;
import leap.web.security.user.UserStore;

public interface SecurityConfig {
    public boolean isEnabled();

    public boolean isCrossContext();

    public boolean isCsrfEnabled();

    public boolean isAuthenticateAnyRequests();

    public boolean isAuthorizeAnyRequests();

    public int getDefaultAuthenticationExpires();

    public String getReturnUrlParameterName();

    public boolean isRememberMeEnabled();

    public String getRememberMeCookieName();

    public String getRememberMeParameterName();

    public String getRememberMeSecret();

    public String getRememberMeExpiresParameterName();

    public int getDefaultRememberMeExpires();

    public String getSecret();

    public String getCsrfHeaderName();

    public String getCsrfParameterName();

    public boolean isAuthenticationTokenEnabled();

    public String getAuthenticationTokenCookieName();

    public String getAuthenticationTokenHeaderName();

    public String getAuthenticationTokenType();

    public String getCookieDomain();

    public String getLoginUrl();

    public String getLoginAction();

    public String getLogoutAction();

    public String getLogoutSuccessUrl();

    public UserStore getUserStore();

    public CsrfStore getCsrfStore();

    public PasswordEncoder getPasswordEncoder();

    public RequestIgnore[] getIgnores();

    public Map<String, SecurityFailureHandler> getPathPrefixFailureHandlers();

    public SecuredPaths getSecuredPaths();

    public SecurityInterceptor[] getInterceptors();
}

