/*
 * Decompiled with CFR 0.152.
 */
package leap.web.security;

import leap.core.ioc.BeanList;
import leap.core.security.crypto.PasswordEncoder;
import leap.web.security.SecurityConfig;
import leap.web.security.SecurityFailureHandler;
import leap.web.security.SecurityInterceptor;
import leap.web.security.csrf.CsrfStore;
import leap.web.security.path.SecuredPaths;
import leap.web.security.user.UserStore;

public interface SecurityConfigurator {
    public SecurityConfig config();

    public SecuredPaths paths();

    default public SecurityConfigurator enable() {
        return this.enable(false);
    }

    default public SecurityConfigurator enable(boolean authenticateAnyRequest) {
        return this.setEnabled(true).setAuthenticateAnyRequests(authenticateAnyRequest);
    }

    default public SecurityConfigurator authenticateAnyRequests() {
        return this.setAuthenticateAnyRequests(true);
    }

    default public SecurityConfigurator allowAnonymousAccessTo(String ... paths) {
        for (String path : paths) {
            this.paths().apply(path, true);
        }
        return this;
    }

    public SecurityConfigurator setEnabled(boolean var1);

    public SecurityConfigurator setCrossContext(boolean var1);

    public SecurityConfigurator setAuthenticateAnyRequests(boolean var1);

    default public SecurityConfigurator authorizeAnyRequests() {
        return this.setAuthenticateAnyRequests(true);
    }

    public SecurityConfigurator setAuthorizeAnyRequests(boolean var1);

    public SecurityConfigurator setUserStore(UserStore var1);

    public SecurityConfigurator setPasswordEncoder(PasswordEncoder var1);

    public SecurityConfigurator setRememberMeEnabled(boolean var1);

    public SecurityConfigurator setRememberMeSecret(String var1);

    public SecurityConfigurator setRememberMeCookieName(String var1);

    public SecurityConfigurator setCsrfEnabled(boolean var1);

    public SecurityConfigurator setCsrfHeaderName(String var1);

    public SecurityConfigurator setCsrfParameterName(String var1);

    public SecurityConfigurator setCsrfStore(CsrfStore var1);

    public SecurityConfigurator setAuthenticationTokenEnabled(boolean var1);

    public SecurityConfigurator setLoginAction(String var1);

    public SecurityConfigurator setLogoutAction(String var1);

    public SecurityConfigurator setLoginUrl(String var1);

    public SecurityConfigurator setPathPrefixFailureHandler(String var1, SecurityFailureHandler var2);

    public SecurityConfigurator ignore(String var1);

    public BeanList<SecurityInterceptor> interceptors();
}

