/*
 * Decompiled with CFR 0.152.
 */
package leap.web.security;

import leap.core.annotation.Inject;
import leap.core.annotation.M;
import leap.core.security.Authentication;
import leap.core.security.Authorization;
import leap.core.web.RequestBase;
import leap.core.web.RequestIgnore;
import leap.lang.Assert;
import leap.lang.Strings;
import leap.lang.intercepting.State;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import leap.web.App;
import leap.web.AppListener;
import leap.web.Request;
import leap.web.RequestExecution;
import leap.web.RequestInterceptor;
import leap.web.Response;
import leap.web.action.ActionContext;
import leap.web.route.Route;
import leap.web.security.DefaultSecurityContextHolder;
import leap.web.security.SecurityConfig;
import leap.web.security.SecurityFailureHandler;
import leap.web.security.SecurityHandler;
import leap.web.security.SecurityInterceptor;
import leap.web.security.csrf.CSRF;
import leap.web.security.csrf.CsrfHandler;
import leap.web.security.path.DefaultSecuredPathBuilder;
import leap.web.security.path.MergedSecuredPath;
import leap.web.security.path.SecuredPath;
import leap.web.security.path.SecuredPathBuilder;
import leap.web.security.path.SecuredPathSource;
import leap.web.security.permission.PermissionManager;

public class SecurityRequestInterceptor
implements RequestInterceptor,
AppListener {
    private static final Log log = LogFactory.get(SecurityRequestInterceptor.class);
    @Inject
    @M
    protected SecurityConfig config;
    @Inject
    @M
    protected PermissionManager perm;
    @Inject
    @M
    protected SecuredPathSource pathSource;
    @Inject
    @M
    protected SecurityHandler handler;
    @Inject
    @M
    protected CsrfHandler csrf;

    protected SecuredPathBuilder spb(Route route) {
        SecuredPathBuilder spb = (SecuredPathBuilder)route.getExtension(SecuredPathBuilder.class);
        if (null == spb) {
            spb = new DefaultSecuredPathBuilder(route);
            route.setExtension(SecuredPathBuilder.class, (Object)spb);
        }
        return spb;
    }

    public void postAppStart(App app) throws Throwable {
        for (Route route : app.routes()) {
            if (null != route.getAllowAnonymous()) {
                this.spb(route).setAllowAnonymous(route.getAllowAnonymous());
            }
            if (null != route.getAllowClientOnly()) {
                this.spb(route).setAllowClientOnly(route.getAllowClientOnly());
            }
            if (null != route.getAllowRememberMe()) {
                this.spb(route).setAllowRememberMe(route.getAllowRememberMe());
            }
            if (null != route.getPermissions()) {
                this.spb(route).setPermissionsAllowed(route.getPermissions());
            }
            if (null != route.getRoles()) {
                this.spb(route).setRolesAllowed(route.getRoles());
            }
            this.config.getPathPrefixFailureHandlers().forEach((prefix, handler) -> {
                if (Strings.startsWith((String)route.getPathTemplate().getTemplate(), (String)prefix)) {
                    log.debug("Set failure handler for path prefix '{}'", new Object[]{route.getPathTemplate()});
                    this.spb(route).setFailureHandler((SecurityFailureHandler)handler);
                }
            });
            SecuredPathBuilder spb = (SecuredPathBuilder)route.removeExtension(SecuredPathBuilder.class);
            if (null == spb) continue;
            route.setExtension(SecuredPath.class, spb.build());
        }
    }

    public State preHandleRequest(Request request, Response response) throws Throwable {
        if (!this.config.isEnabled()) {
            log.debug("Web security not enabled, ignore the interceptor");
            return State.CONTINUE;
        }
        if (State.isIntercepted((State)this.csrf.handleRequest(request, response))) {
            return State.INTERCEPTED;
        }
        for (RequestIgnore ignore : this.config.getIgnores()) {
            if (!ignore.matches((RequestBase)request)) continue;
            return State.CONTINUE;
        }
        DefaultSecurityContextHolder context = new DefaultSecurityContextHolder(this.config, this.perm, request);
        return this.preHandleRequest(request, response, context);
    }

    protected State preHandleRequest(Request request, Response response, DefaultSecurityContextHolder context) throws Throwable {
        if (this.handleLoginRequest(request, response, context)) {
            return State.INTERCEPTED;
        }
        if (this.handleLogoutRequest(request, response, context)) {
            return State.INTERCEPTED;
        }
        State state = this.resolveAuthentication(request, response, context);
        if (state.isIntercepted()) {
            return state;
        }
        if (!context.getAuthentication().isAuthenticated()) {
            CSRF.ignore(request);
        }
        return State.CONTINUE;
    }

    public State handleRoute(Request request, Response response, Route route, ActionContext ac) throws Throwable {
        return this.handleSecurity(request, response, route);
    }

    public State handleNoRoute(Request request, Response response) throws Throwable {
        return this.handleSecurity(request, response, null);
    }

    protected State handleSecurity(Request request, Response response, Route route) throws Throwable {
        DefaultSecurityContextHolder context = DefaultSecurityContextHolder.tryGet(request);
        if (null == context || context.isHandled()) {
            return State.CONTINUE;
        }
        context.markHandled();
        context.setSecuredPath(this.resolveSecuredPath(request, response, context, route));
        State state = this.checkAuthentication(request, response, context);
        if (state.isIntercepted()) {
            return state;
        }
        state = this.resolveAuthorization(request, response, context);
        if (state.isIntercepted()) {
            return state;
        }
        return this.checkAuthorization(request, response, context);
    }

    public void completeHandleRequest(Request request, Response response, RequestExecution execution) throws Throwable {
        DefaultSecurityContextHolder.remove(request);
    }

    protected State resolveAuthentication(Request request, Response response, DefaultSecurityContextHolder context) throws Throwable {
        SecurityInterceptor[] interceptors = this.config.getInterceptors();
        for (SecurityInterceptor interceptor : this.config.getInterceptors()) {
            if (!interceptor.preResolveAuthentication(request, response, context).isIntercepted()) continue;
            log.debug("Intercepted by interceptor : {}", new Object[]{interceptor.getClass()});
            return State.INTERCEPTED;
        }
        Authentication authc = context.getAuthentication();
        if (null == authc) {
            log.debug("Resolving authentication...");
            authc = this.handler.resolveAuthentication(request, response, context);
            Assert.notNull((Object)authc, (String)"'Authentication' must not be null");
            context.setAuthentication(authc);
        } else {
            log.debug("Authentication already resolved by interceptor -> {}", new Object[]{authc});
        }
        if (log.isDebugEnabled()) {
            if (authc.isAuthenticated()) {
                log.debug("Request authenticated to : {}", new Object[]{authc});
            } else {
                log.debug("Request not authenticated!");
            }
        }
        request.setAuthentication(authc);
        request.setUser(authc.getUser());
        for (SecurityInterceptor interceptor : interceptors) {
            if (!interceptor.postResolveAuthentication(request, response, context).isIntercepted()) continue;
            return State.INTERCEPTED;
        }
        return State.CONTINUE;
    }

    protected boolean handleLoginRequest(Request request, Response response, DefaultSecurityContextHolder context) throws Throwable {
        return this.handler.handleLoginRequest(request, response, context);
    }

    protected boolean handleLogoutRequest(Request request, Response response, DefaultSecurityContextHolder context) throws Throwable {
        return this.handler.handleLogoutRequest(request, response, context);
    }

    protected SecuredPath resolveSecuredPath(Request request, Response response, DefaultSecurityContextHolder context, Route route) throws Throwable {
        SecuredPath p1 = null == route ? null : (SecuredPath)route.getExtension(SecuredPath.class);
        SecuredPath p2 = this.pathSource.getSecuredPath(context, request);
        if (null == p1) {
            return p2;
        }
        if (null == p2) {
            return p1;
        }
        return new MergedSecuredPath(route, p1, p2);
    }

    protected State checkAuthentication(Request request, Response response, DefaultSecurityContextHolder context) throws Throwable {
        if (!this.handler.checkAuthentication(request, response, context)) {
            this.handler.handleAuthenticationDenied(request, response, context);
            return State.INTERCEPTED;
        }
        return State.CONTINUE;
    }

    protected State resolveAuthorization(Request request, Response response, DefaultSecurityContextHolder context) throws Throwable {
        SecurityInterceptor[] interceptors;
        for (SecurityInterceptor si : interceptors = this.config.getInterceptors()) {
            if (!State.isIntercepted((State)si.preResolveAuthorization(request, response, context))) continue;
            return State.INTERCEPTED;
        }
        Authorization authz = context.getAuthorization();
        if (null == authz) {
            log.debug("Resolving authorization...");
            authz = this.handler.resolveAuthorization(request, response, context);
            Assert.notNull((Object)authz, (String)"The authorization must not be null");
            context.setAuthorization(authz);
        } else {
            log.debug("Authorization already resolved by interceptor -> {}", new Object[]{authz});
        }
        for (SecurityInterceptor si : interceptors) {
            if (!State.isIntercepted((State)si.postResolveAuthorization(request, response, context))) continue;
            return State.INTERCEPTED;
        }
        return State.CONTINUE;
    }

    protected State checkAuthorization(Request request, Response response, DefaultSecurityContextHolder context) throws Throwable {
        if (!this.handler.checkAuthorization(request, response, context)) {
            this.handler.handleAuthorizationDenied(request, response, context);
            return State.INTERCEPTED;
        }
        return State.CONTINUE;
    }
}

