/*
 * Decompiled with CFR 0.152.
 */
package leap.web.security.authc;

import leap.core.annotation.Inject;
import leap.core.security.Anonymous;
import leap.core.security.Authentication;
import leap.core.security.ClientPrincipal;
import leap.core.security.Credentials;
import leap.core.security.UserPrincipal;
import leap.core.web.RequestBase;
import leap.lang.Out;
import leap.lang.Result;
import leap.lang.Strings;
import leap.lang.intercepting.State;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import leap.web.Request;
import leap.web.RequestIntercepted;
import leap.web.Response;
import leap.web.security.SecurityConfig;
import leap.web.security.SecuritySessionManager;
import leap.web.security.authc.AuthenticationContext;
import leap.web.security.authc.AuthenticationManager;
import leap.web.security.authc.AuthenticationResolver;
import leap.web.security.authc.RememberMeManager;
import leap.web.security.authc.SimpleAuthentication;
import leap.web.security.authc.TokenAuthenticationManager;
import leap.web.security.authc.credentials.CredentialsAuthenticationContext;
import leap.web.security.authc.credentials.CredentialsAuthenticator;

public class DefaultAuthenticationManager
implements AuthenticationManager {
    private static final Log log = LogFactory.get(DefaultAuthenticationManager.class);
    @Inject
    protected SecurityConfig securityConfig;
    @Inject
    protected AuthenticationResolver[] resolvers;
    @Inject
    protected SecuritySessionManager sessionManager;
    @Inject
    protected TokenAuthenticationManager tokenAuthenticationManager;
    @Inject
    protected RememberMeManager rememberMeManager;
    @Inject
    protected CredentialsAuthenticator[] credentialsAuthenticators;

    @Override
    public Authentication authenticate(CredentialsAuthenticationContext context, Credentials credentials) {
        Out user = new Out();
        for (CredentialsAuthenticator a : this.credentialsAuthenticators) {
            if (a.authenticate(context, credentials, (Out<UserPrincipal>)user)) break;
        }
        if (null != user.getValue()) {
            return new SimpleAuthentication((UserPrincipal)user.getValue(), credentials);
        }
        return null;
    }

    @Override
    public Authentication resolveAuthentication(Request request, Response response, AuthenticationContext context) throws Throwable {
        Authentication authc = null;
        if (State.isContinue((State)this.tokenAuthenticationManager.preResolveAuthentication(request, response, context))) {
            authc = context.getAuthentication();
            if (null == authc) {
                for (AuthenticationResolver h : this.resolvers) {
                    Result<Authentication> r = h.resolveAuthentication(request, response, context);
                    if (null == r || r.isEmpty()) continue;
                    if (r.isIntercepted()) {
                        RequestIntercepted.throwIt();
                    }
                    if (!r.isPresent()) continue;
                    authc = (Authentication)r.get();
                    break;
                }
                if (null == authc) {
                    authc = this.sessionManager.getAuthentication((RequestBase)request);
                    if (null != authc) {
                        return authc;
                    }
                    authc = (Authentication)Result.value(this.tokenAuthenticationManager.resolveAuthentication(request, response, context));
                    if (null == authc) {
                        authc = (Authentication)Result.value(this.rememberMeManager.resolveAuthentication(request, response, context));
                    }
                }
            }
            if (null != authc) {
                if (null == authc.getUser()) {
                    authc = new WrappedAuthentication(authc, this.createAnonymous(request, response, context));
                }
                if (authc.isAuthenticated() && !authc.isClientOnly()) {
                    this.loginImmediately(request, response, authc);
                }
            }
        }
        return null == authc ? this.createAnonymousAuthentication(request, response, context) : authc;
    }

    @Override
    public void loginImmediately(Request request, Response response, Authentication authc) {
        log.debug("User {} logged in", new Object[]{authc.getUser().getLoginName()});
        this.saveAuthentication(request, response, authc);
        if (this.securityConfig.isAuthenticationTokenEnabled()) {
            this.tokenAuthenticationManager.onLoginSuccess(request, response, authc);
        }
        if (this.securityConfig.isRememberMeEnabled() && !authc.isRememberMe()) {
            this.rememberMeManager.onLoginSuccess(request, response, authc);
        }
        for (AuthenticationResolver h : this.resolvers) {
            h.onLoginSuccess(request, response, authc);
        }
    }

    @Override
    public void logoutImmediately(Request request, Response response) {
        this.sessionManager.removeAuthentication((RequestBase)request);
        if (this.securityConfig.isAuthenticationTokenEnabled()) {
            this.tokenAuthenticationManager.onLogoutSuccess(request, response);
        }
        if (this.securityConfig.isRememberMeEnabled()) {
            this.rememberMeManager.onLogoutSuccess(request, response);
        }
        for (AuthenticationResolver h : this.resolvers) {
            h.onLogoutSuccess(request, response);
        }
    }

    protected void saveAuthentication(Request request, Response response, Authentication authentication) {
        this.sessionManager.saveAuthentication((RequestBase)request, authentication);
    }

    protected Authentication createAnonymousAuthentication(Request request, Response response, AuthenticationContext context) {
        return new SimpleAuthentication(this.createAnonymous(request, response, context));
    }

    @Override
    public UserPrincipal createAnonymous(Request request, Response response, AuthenticationContext context) {
        String name = request.getMessageSource().getMessage("websecurity.anonymous.name", new Object[0]);
        if (Strings.isEmpty((String)name)) {
            name = "Anonymous";
        }
        return new Anonymous(name);
    }

    protected static final class WrappedAuthentication
    implements Authentication {
        private final Authentication wrapped;
        private final UserPrincipal user;

        WrappedAuthentication(Authentication wrapped, UserPrincipal user) {
            this.wrapped = wrapped;
            this.user = user;
        }

        public boolean isAuthenticated() {
            return this.wrapped.isAuthenticated();
        }

        public boolean isRememberMe() {
            return this.wrapped.isRememberMe();
        }

        public Object getCredentials() {
            return this.wrapped.getCredentials();
        }

        public UserPrincipal getUser() {
            return this.user;
        }

        public ClientPrincipal getClient() {
            return this.wrapped.getClient();
        }

        public String getToken() {
            return this.wrapped.getToken();
        }

        public void setToken(String token) throws IllegalStateException {
            this.wrapped.setToken(token);
        }

        public String[] getPermissions() {
            return this.wrapped.getPermissions();
        }

        public void setPermissions(String ... permissions) {
            this.wrapped.setPermissions(permissions);
        }

        public String[] getRoles() {
            return this.wrapped.getRoles();
        }

        public void setRoles(String ... roles) {
            this.wrapped.setRoles(roles);
        }

        public String toString() {
            return this.wrapped.toString();
        }
    }
}

