/*
 * Decompiled with CFR 0.152.
 */
package leap.web.security.authc;

import javax.servlet.http.Cookie;
import leap.core.security.Authentication;
import leap.core.security.UserPrincipal;
import leap.lang.Result;
import leap.lang.Strings;
import leap.lang.codec.Base64;
import leap.lang.codec.MD5;
import leap.lang.convert.Converts;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import leap.web.Request;
import leap.web.Response;
import leap.web.security.authc.AuthenticationContext;
import leap.web.security.authc.CookieBasedAuthenticationResolver;
import leap.web.security.authc.RememberMeException;
import leap.web.security.authc.RememberMeManager;
import leap.web.security.authc.SimpleAuthentication;
import leap.web.security.user.UserDetails;
import leap.web.security.user.UserStore;

public class DefaultRememberMeManager
extends CookieBasedAuthenticationResolver
implements RememberMeManager {
    private static final Log log = LogFactory.get(DefaultRememberMeManager.class);

    @Override
    public Result<Authentication> resolveAuthentication(Request request, Response response, AuthenticationContext context) {
        Cookie cookie = this.getCookie(request);
        if (null == cookie) {
            return Result.empty();
        }
        if (Strings.isEmpty((String)cookie.getValue())) {
            return Result.empty();
        }
        String[] tokens = this.decodeRememberMeTokens(cookie);
        if (null == tokens) {
            return Result.empty();
        }
        log.debug("A valid remember-me cookie detected, authenticates it");
        Authentication authc = this.authenticateRememberMeTokens(request, response, context, tokens);
        if (null == authc) {
            log.debug("Failed authenticating the remember-me cookie, removes it");
            this.removeCookie(request, response, cookie);
            return Result.empty();
        }
        log.debug("Successful to authenticating the remember-me cookie");
        return Result.of((Object)authc);
    }

    @Override
    public void forgetRememberedUser(Request request, Response response) {
        this.removeCookie(request, response);
    }

    @Override
    public void onLoginSuccess(Request request, Response response, Authentication authentication) {
        UserPrincipal user = authentication.getUser();
        if (user instanceof UserDetails) {
            String rememberMe = request.getParameter(this.securityConfig.getRememberMeParameterName());
            if (Converts.toBoolean((String)rememberMe, (boolean)false)) {
                this.setRememberMeCookie(request, response, user.getLoginName(), ((UserDetails)user).getPassword());
            } else {
                this.removeCookie(request, response);
            }
        }
    }

    @Override
    public void onLogoutSuccess(Request request, Response response) {
        this.forgetRememberedUser(request, response);
    }

    protected void setRememberMeCookie(Request request, Response response, String username, String password) {
        int maxAge = this.getCookieMaxAge(request);
        long expires = System.currentTimeMillis() + (long)maxAge * 1000L;
        String tokens = this.encodeRememberMeTokens(username, password, expires);
        this.setCookie(request, response, tokens, maxAge);
    }

    protected String encodeRememberMeTokens(String username, String password, long expires) {
        String key = this.securityConfig.getRememberMeSecret();
        if (Strings.isEmpty((String)key)) {
            throw new RememberMeException("Cannot sign the remember-me tokens, secret must be provided");
        }
        String signed = this.sign(username, password, expires);
        String data = username + ":" + String.valueOf(expires) + ":" + signed;
        StringBuilder sb = new StringBuilder(Base64.encode((String)data));
        while (sb.charAt(sb.length() - 1) == '=') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    protected String[] decodeRememberMeTokens(Cookie cookie) {
        String encodedTokenString = cookie.getValue();
        for (int j = 0; j < encodedTokenString.length() % 4; ++j) {
            encodedTokenString = encodedTokenString + "=";
        }
        if (!Base64.isBase64((String)encodedTokenString)) {
            log.debug("The remember-me cookie is not a valid base64 string");
            return null;
        }
        String decodedTokenString = Base64.decode((String)encodedTokenString);
        String[] tokens = Strings.split((String)decodedTokenString, (char)':');
        if (tokens.length != 3) {
            return null;
        }
        return tokens;
    }

    protected Authentication authenticateRememberMeTokens(Request request, Response response, AuthenticationContext context, String[] tokens) {
        String username;
        long expires;
        try {
            expires = new Long(tokens[1]);
        }
        catch (NumberFormatException nfe) {
            log.debug("Remember-me token[1] did not contain a valid expires number, actual is : {}", new Object[]{tokens[1]});
            return null;
        }
        if (this.isTokenExpired(expires)) {
            log.debug("Remember-me token has expired");
            return null;
        }
        UserStore userStore = this.securityConfig.getUserStore();
        UserDetails user = userStore.loadUserDetailsByLoginName(username = tokens[0]);
        if (null == user) {
            log.debug("The remembered user '{}' not found", new Object[]{username});
            return null;
        }
        String signed = this.sign(username, user.getPassword(), expires);
        if (null == signed) {
            return null;
        }
        if (!signed.equals(tokens[2])) {
            log.debug("The remembered user's signed is invalid, may be the user's password was changed");
            return null;
        }
        SimpleAuthentication authc = new SimpleAuthentication(user);
        authc.setRememberMe(true);
        return authc;
    }

    protected String sign(String username, String password, long expires) {
        String key = this.securityConfig.getRememberMeSecret();
        if (Strings.isEmpty((String)key)) {
            log.debug("Remember-me secret not exists, cannot sign user tokens");
            return null;
        }
        String data = username + ":" + expires + ":" + password + ":" + key;
        return MD5.hex((byte[])Strings.getBytesUtf8((String)data));
    }

    public String getCookieExpiresParameter() {
        return this.securityConfig.getRememberMeExpiresParameterName();
    }

    public int getCookieExpires() {
        return this.securityConfig.getDefaultRememberMeExpires();
    }

    public String getCookieName() {
        return this.securityConfig.getRememberMeCookieName();
    }

    protected boolean isTokenExpired(long expires) {
        return expires < System.currentTimeMillis();
    }
}

