/*
 * Decompiled with CFR 0.152.
 */
package leap.web.security.authc;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import leap.core.AppConfigException;
import leap.core.BeanFactory;
import leap.core.annotation.Inject;
import leap.core.ioc.PostCreateBean;
import leap.core.security.Authentication;
import leap.core.security.Credentials;
import leap.core.security.UserPrincipal;
import leap.core.security.token.SimpleTokenCredentials;
import leap.core.security.token.TokenVerifyException;
import leap.core.web.RequestBase;
import leap.lang.Out;
import leap.lang.Result;
import leap.lang.Strings;
import leap.lang.codec.Base64;
import leap.lang.intercepting.State;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import leap.web.Request;
import leap.web.Response;
import leap.web.security.SecurityConfig;
import leap.web.security.SecuritySessionManager;
import leap.web.security.authc.AuthenticationContext;
import leap.web.security.authc.CookieBasedAuthenticationResolver;
import leap.web.security.authc.SimpleAuthentication;
import leap.web.security.authc.TokenAuthenticationManager;
import leap.web.security.authc.TokenAuthenticator;

public class DefaultTokenAuthenticationManager
extends CookieBasedAuthenticationResolver
implements TokenAuthenticationManager,
PostCreateBean {
    private static final Log log = LogFactory.get(DefaultTokenAuthenticationManager.class);
    @Inject
    protected SecurityConfig securityConfig;
    @Inject
    protected SecuritySessionManager sessionManager;
    protected TokenAuthenticator tokenAuthenticator;
    protected String logoutToken;

    public String getLogoutToken() {
        if (null == this.logoutToken) {
            this.logoutToken = Base64.urlEncode((String)"logout");
        }
        return this.logoutToken;
    }

    public void setLogoutToken(String token) {
        this.logoutToken = token;
    }

    @Override
    public State preResolveAuthentication(Request request, Response response, AuthenticationContext context) throws Throwable {
        if (!this.securityConfig.isAuthenticationTokenEnabled()) {
            return State.CONTINUE;
        }
        String token = this.getToken(request);
        if (this.getLogoutToken().equals(token)) {
            this.sessionManager.removeAuthentication((RequestBase)request);
        }
        context.setAuthenticationToken(token);
        return State.CONTINUE;
    }

    @Override
    public Result<Authentication> resolveAuthentication(Request request, Response response, AuthenticationContext context) throws ServletException, IOException {
        if (!this.securityConfig.isAuthenticationTokenEnabled()) {
            return Result.empty();
        }
        String token = context.getAuthenticationToken();
        if (Strings.isEmpty((String)token)) {
            return Result.empty();
        }
        if (this.getLogoutToken().equals(token)) {
            return Result.empty();
        }
        SimpleTokenCredentials credentials = new SimpleTokenCredentials(token);
        Out outPrincipal = new Out();
        try {
            if (log.isDebugEnabled()) {
                log.debug("Authenticates the auth token : {}", new Object[]{Strings.abbreviate((String)token, (int)10) + "******"});
            }
            if (!this.tokenAuthenticator.authenticate(context, (Credentials)credentials, (Out<UserPrincipal>)outPrincipal)) {
                return Result.empty();
            }
        }
        catch (TokenVerifyException e) {
            log.info("Token verify error, " + e.getMessage(), (Throwable)e);
            this.removeCookie(request, response);
            return Result.empty();
        }
        UserPrincipal principal = (UserPrincipal)outPrincipal.getValue();
        if (null == principal) {
            throw new IllegalStateException("Credentials '" + credentials + "' authenticated but no principal was returned");
        }
        Authentication authc = this.sessionManager.getAuthentication((RequestBase)request);
        if (null != authc && !principal.getId().equals(authc.getUser().getId())) {
            this.sessionManager.removeAuthentication((RequestBase)request);
        }
        authc = new TokenAuthentication(principal, (Credentials)credentials);
        authc.setToken(token);
        return Result.of((Object)authc);
    }

    @Override
    public void onLoginSuccess(Request request, Response response, Authentication authc) {
        if (authc instanceof TokenAuthentication) {
            return;
        }
        String token = this.tokenAuthenticator.generateAuthenticationToken(request, response, authc);
        authc.setToken(token);
        this.setCookie(request, response, token);
    }

    @Override
    public void onLogoutSuccess(Request request, Response response) {
        this.setCookie(request, response, this.getLogoutToken());
    }

    protected String getToken(Request request) {
        Cookie cookie;
        String token = request.getHeader(this.securityConfig.getAuthenticationTokenHeaderName());
        if (Strings.isEmpty((String)token) && null != (cookie = request.getCookie(this.getCookieName(request)))) {
            token = cookie.getValue();
        }
        return token;
    }

    public int getCookieExpires() {
        return -1;
    }

    public String getCookieName() {
        return this.securityConfig.getAuthenticationTokenCookieName();
    }

    public String getCookieExpiresParameter() {
        return null;
    }

    public void postCreate(BeanFactory factory) throws Throwable {
        String tokenType = this.securityConfig.getAuthenticationTokenType();
        if (Strings.isEmpty((String)tokenType)) {
            throw new AppConfigException("Default token type must be configured for token based authentication");
        }
        this.tokenAuthenticator = (TokenAuthenticator)factory.tryGetBean(TokenAuthenticator.class, tokenType);
        if (null == this.tokenAuthenticator) {
            throw new AppConfigException("Bean of type '" + TokenAuthenticator.class.getSimpleName() + "' and named '" + tokenType + "' does not exists");
        }
    }

    protected static final class TokenAuthentication
    extends SimpleAuthentication {
        public TokenAuthentication(UserPrincipal user, Credentials credentials) {
            super(user, credentials);
        }
    }
}

