/*
 * Decompiled with CFR 0.152.
 */
package leap.web.security.authz;

import leap.core.annotation.Inject;
import leap.core.annotation.M;
import leap.core.security.Authorization;
import leap.core.web.RequestBase;
import leap.lang.Result;
import leap.web.Request;
import leap.web.RequestIntercepted;
import leap.web.Response;
import leap.web.security.SecurityConfig;
import leap.web.security.authz.AuthorizationChecker;
import leap.web.security.authz.AuthorizationContext;
import leap.web.security.authz.AuthorizationManager;
import leap.web.security.authz.AuthorizationResolver;

public class DefaultAuthorizationManager
implements AuthorizationManager {
    protected static final Authorization EMPTY_AUTHZ = new Authorization(){};
    @Inject
    @M
    protected SecurityConfig config;
    @Inject
    @M
    protected AuthorizationResolver[] resolvers;
    @Inject
    @M
    protected AuthorizationChecker[] checkers;

    @Override
    public Authorization resolveAuthorization(Request request, Response response, AuthorizationContext context) throws Throwable {
        for (AuthorizationResolver resolver : this.resolvers) {
            Result<Authorization> r = resolver.resolveAuthorization((RequestBase)request, response, context);
            if (null == r || r.isEmpty()) continue;
            if (r.isIntercepted()) {
                RequestIntercepted.throwIt();
            }
            if (!r.isPresent()) continue;
            return (Authorization)r.get();
        }
        return EMPTY_AUTHZ;
    }

    @Override
    public boolean checkAuthorization(Request request, Response response, AuthorizationContext context) throws Throwable {
        for (AuthorizationChecker checker : this.checkers) {
            if (checker.check((RequestBase)request, response, context.getAuthorization(), context)) continue;
            return false;
        }
        return true;
    }
}

