/*
 * Decompiled with CFR 0.152.
 */
package leap.web.security.csrf;

import javax.servlet.http.HttpServletRequest;
import leap.core.web.RequestBase;
import leap.web.Request;
import leap.web.security.csrf.CsrfToken;

public class CSRF {
    static final String GENERATED_TOKEN_KEY = CsrfToken.class.getName();
    static final String REQUEST_TOKEN_KEY = CsrfToken.class.getName() + "$req";
    static final String CSRF_IGNORED_KEY = CsrfToken.class.getName() + "$ignored";

    public static CsrfToken getGeneratedToken(HttpServletRequest request) {
        return (CsrfToken)request.getAttribute(GENERATED_TOKEN_KEY);
    }

    public static CsrfToken getGeneratedToken(RequestBase request) {
        return (CsrfToken)request.getAttribute(GENERATED_TOKEN_KEY);
    }

    static void setGeneratedToken(RequestBase request, CsrfToken token) {
        request.setAttribute(GENERATED_TOKEN_KEY, (Object)token);
    }

    public static String getRequestToken(RequestBase request) {
        return (String)request.getAttribute(REQUEST_TOKEN_KEY);
    }

    public static void setRequestToken(RequestBase request, String token) {
        request.setAttribute(REQUEST_TOKEN_KEY, (Object)token);
    }

    public static void setRequestToken(HttpServletRequest request, String token) {
        request.setAttribute(REQUEST_TOKEN_KEY, (Object)token);
    }

    public static void ignore(HttpServletRequest request) {
        request.setAttribute(CSRF_IGNORED_KEY, (Object)Boolean.TRUE);
    }

    public static boolean isIgnored(HttpServletRequest request) {
        Object v = request.getAttribute(CSRF_IGNORED_KEY);
        return Boolean.TRUE == v;
    }

    public static void ignore(Request request) {
        request.setAttribute(CSRF_IGNORED_KEY, (Object)Boolean.TRUE);
    }

    public static boolean isIgnored(Request request) {
        Object v = request.getAttribute(CSRF_IGNORED_KEY);
        return Boolean.TRUE == v;
    }

    protected CSRF() {
    }
}

