/*
 * Decompiled with CFR 0.152.
 */
package leap.web.security.csrf;

import leap.core.annotation.Inject;
import leap.core.validation.Validation;
import leap.core.web.RequestBase;
import leap.lang.Strings;
import leap.lang.http.HTTP;
import leap.lang.intercepting.State;
import leap.web.Request;
import leap.web.action.ActionContext;
import leap.web.action.ActionInterceptor;
import leap.web.route.Route;
import leap.web.security.SecurityConfig;
import leap.web.security.csrf.CSRF;
import leap.web.security.csrf.CsrfManager;
import leap.web.security.csrf.CsrfToken;
import leap.web.security.csrf.InvalidCsrfTokenException;
import leap.web.security.csrf.MissingCsrfTokenException;

public class CsrfActionInterceptor
implements ActionInterceptor {
    @Inject
    protected SecurityConfig securityConfig;
    @Inject
    protected CsrfManager csrfManager;

    public State preExecuteAction(ActionContext context, Validation validation) throws Throwable {
        if (!this.isEnabled(context)) {
            return State.CONTINUE;
        }
        Request request = context.getRequest();
        if (request.isMethod(HTTP.Method.GET)) {
            return State.CONTINUE;
        }
        if (CSRF.isIgnored(request.getServletRequest())) {
            return State.CONTINUE;
        }
        CsrfToken token = CSRF.getGeneratedToken((RequestBase)request);
        this.checkCsrfToken(request, token);
        return State.CONTINUE;
    }

    protected boolean isEnabled(ActionContext context) {
        Route route = context.getRoute();
        if (route.isCsrfEnabled()) {
            return true;
        }
        if (route.isCsrfDisabled()) {
            return false;
        }
        return this.securityConfig.isCsrfEnabled();
    }

    protected void checkCsrfToken(Request request, CsrfToken expected) throws Throwable {
        String requestedToken = this.getCsrfTokenString(request);
        if (!this.csrfManager.verifyToken(request, requestedToken, expected)) {
            if (expected.isNew()) {
                throw new MissingCsrfTokenException("Expected CSRF token not found. Has your session expired?");
            }
            throw new InvalidCsrfTokenException("Invalid CSRF Token '" + requestedToken + "' was found on the request parameter '" + this.securityConfig.getCsrfParameterName() + "' or header '" + this.securityConfig.getCsrfHeaderName() + "'.");
        }
    }

    protected String getCsrfTokenString(Request request) {
        String token = request.getHeader(this.securityConfig.getCsrfHeaderName());
        if (Strings.isEmpty((String)token) && Strings.isEmpty((String)(token = request.getParameter(this.securityConfig.getCsrfParameterName())))) {
            token = CSRF.getRequestToken((RequestBase)request);
        }
        return token;
    }
}

