/*
 * Decompiled with CFR 0.152.
 */
package leap.web.security.csrf;

import java.util.Map;
import leap.core.annotation.Inject;
import leap.core.web.RequestBase;
import leap.htpl.HtplContext;
import leap.htpl.HtplDocument;
import leap.htpl.HtplEngine;
import leap.htpl.ast.Element;
import leap.htpl.ast.If;
import leap.htpl.ast.IfCondition;
import leap.htpl.ast.Node;
import leap.htpl.interceptor.ElementProcessInterceptor;
import leap.lang.expression.AbstractExpression;
import leap.lang.expression.Expression;
import leap.web.security.SecurityConfig;
import leap.web.security.csrf.CSRF;
import leap.web.security.csrf.CsrfToken;

public class CsrfFormInterceptor
extends ElementProcessInterceptor {
    @Inject
    protected SecurityConfig config;

    protected void preProcessElement(HtplEngine engine, HtplDocument document, Element e) throws Throwable {
        String param = this.config.getCsrfParameterName();
        if (e.getLocalName().equalsIgnoreCase("form")) {
            if (null != e.findElement(e1 -> e1.getLocalName().equalsIgnoreCase("input") && param.equals(e1.getAttributeValue("name")))) {
                return;
            }
            IfCondition cond = new IfCondition("csrf_token", (Expression)new AbstractExpression(){

                protected Object eval(Object context, Map<String, Object> vars) {
                    HtplContext hc;
                    RequestBase request;
                    if (CsrfFormInterceptor.this.config.isCsrfEnabled() && null != (request = (hc = (HtplContext)context).getRequest())) {
                        CsrfToken token = CSRF.getGeneratedToken(request);
                        if (null != token) {
                            hc.setLocalVariable("csrf_token_string", (Object)token.getToken());
                        }
                        return true;
                    }
                    return false;
                }
            });
            Element csrfElement = new Element(null, "input");
            csrfElement.setAttribute("name", param);
            csrfElement.setAttribute("type", "hidden");
            csrfElement.setAttribute("value", "${csrf_token_string}");
            csrfElement.setSelfClosing(true);
            cond.addChildNode((Node)csrfElement);
            e.childNodes().add(0, new If(cond));
        }
    }
}

