/*
 * Decompiled with CFR 0.152.
 */
package leap.web.security.csrf;

import leap.core.annotation.Inject;
import leap.core.web.RequestBase;
import leap.lang.intercepting.State;
import leap.web.Request;
import leap.web.Response;
import leap.web.security.SecurityConfig;
import leap.web.security.csrf.CSRF;
import leap.web.security.csrf.CsrfHandler;
import leap.web.security.csrf.CsrfManager;
import leap.web.security.csrf.SimpleCsrfToken;

public class DefaultCsrfHandler
implements CsrfHandler {
    @Inject
    protected SecurityConfig config;
    @Inject
    protected CsrfManager manager;

    @Override
    public State handleRequest(Request request, Response response) throws Throwable {
        if (!this.config.isCsrfEnabled()) {
            return State.CONTINUE;
        }
        SimpleCsrfToken token = null;
        String savedToken = this.manager.loadToken(request);
        if (null == savedToken) {
            savedToken = this.manager.generateToken(request);
            token = new SaveOnAccessCsrfToken(this.config, savedToken, request, this.manager);
        } else {
            token = new SimpleCsrfToken(this.config, savedToken, false);
        }
        CSRF.setGeneratedToken((RequestBase)request, token);
        request.setAttribute(this.config.getCsrfParameterName(), (Object)token);
        return State.CONTINUE;
    }

    protected static class SaveOnAccessCsrfToken
    extends SimpleCsrfToken {
        private final Request request;
        private final CsrfManager manager;
        private boolean saved;

        public SaveOnAccessCsrfToken(SecurityConfig config, String token, Request request, CsrfManager manager) {
            super(config, token, true);
            this.request = request;
            this.manager = manager;
        }

        @Override
        public String getToken() {
            if (!this.saved) {
                try {
                    this.manager.saveToken(this.request, this.token);
                }
                catch (Throwable e) {
                    throw new IllegalStateException("Error saving csrf token , " + e.getMessage(), e);
                }
                this.saved = true;
            }
            return this.token;
        }

        @Override
        public String toString() {
            return this.getToken();
        }
    }
}

