/*
 * Decompiled with CFR 0.152.
 */
package leap.web.security.csrf;

import java.util.concurrent.atomic.AtomicInteger;
import leap.core.BeanFactory;
import leap.core.annotation.Inject;
import leap.core.ioc.PostCreateBean;
import leap.core.security.token.SimpleTokenEncoder;
import leap.core.security.token.TokenEncoder;
import leap.core.security.token.TokenExpiredException;
import leap.web.Request;
import leap.web.security.SecurityConfig;
import leap.web.security.csrf.CsrfManager;
import leap.web.security.csrf.CsrfToken;
import leap.web.security.csrf.CsrfTokenExpiredException;

public class DefaultCsrfManager
implements CsrfManager,
PostCreateBean {
    private final AtomicInteger counter = new AtomicInteger();
    @Inject
    protected SecurityConfig sc;
    protected TokenEncoder tokenEncoder;

    @Override
    public String generateToken(Request request) throws Throwable {
        return this.doGenerateToken();
    }

    @Override
    public String loadToken(Request request) throws Throwable {
        return this.sc.getCsrfStore().loadToken(request);
    }

    @Override
    public boolean verifyToken(Request request, String token, CsrfToken expected) throws CsrfTokenExpiredException {
        try {
            return null == token ? false : this.tokenEncoder.verifyToken(token);
        }
        catch (TokenExpiredException e) {
            throw new CsrfTokenExpiredException(e.getMessage());
        }
    }

    @Override
    public void saveToken(Request request, String token) throws Throwable {
        this.sc.getCsrfStore().saveToken(request, token);
    }

    @Override
    public void removeToken(Request request) throws Throwable {
        this.sc.getCsrfStore().removeToken(request);
    }

    protected String doGenerateToken() {
        String value = String.valueOf(this.counter.incrementAndGet());
        return this.tokenEncoder.encodeToken(value);
    }

    public void postCreate(BeanFactory factory) throws Throwable {
        if (null == this.tokenEncoder) {
            this.tokenEncoder = new SimpleTokenEncoder(this.sc.getSecret(), this.sc.getDefaultAuthenticationExpires());
        }
    }
}

