/*
 * Decompiled with CFR 0.152.
 */
package leap.web.security.csrf;

import leap.core.Session;
import leap.web.Request;
import leap.web.security.csrf.CsrfStore;

public class SessionCsrfStore
implements CsrfStore {
    private static final String KEY = SessionCsrfStore.class.getName() + "$token";

    @Override
    public String loadToken(Request request) throws Throwable {
        Session session = request.getSession(false);
        if (null == session) {
            return null;
        }
        return (String)session.getAttribute(KEY);
    }

    @Override
    public void saveToken(Request request, String token) throws Throwable {
        Session session = request.getSession();
        session.setAttribute(KEY, (Object)token);
    }

    @Override
    public void removeToken(Request request) throws Throwable {
        Session session = request.getSession(false);
        if (null != session) {
            session.removeAttribute(KEY);
        }
    }
}

