/*
 * Decompiled with CFR 0.152.
 */
package leap.web.security.login;

import leap.core.annotation.Inject;
import leap.core.security.Authentication;
import leap.core.security.Credentials;
import leap.lang.intercepting.State;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import leap.web.Request;
import leap.web.Response;
import leap.web.security.authc.AuthenticationException;
import leap.web.security.authc.AuthenticationManager;
import leap.web.security.login.LoginContext;
import leap.web.security.login.LoginHandler;

public class CredentialsAuthenticationHandler
implements LoginHandler {
    private static final Log log = LogFactory.get(CredentialsAuthenticationHandler.class);
    @Inject
    protected AuthenticationManager authenticationManager;

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    @Override
    public State handleLoginAuthentication(Request request, Response response, LoginContext context) throws Throwable {
        Credentials credentials;
        if (!context.isError() && null != (credentials = context.getCredentials())) {
            try {
                Authentication authc = this.authenticationManager.authenticate(context, credentials);
                if (null != authc) {
                    context.setUser(authc.getUser());
                }
            }
            catch (AuthenticationException e) {
                log.error(e.getMessage(), (Throwable)((Object)e));
            }
        }
        return State.CONTINUE;
    }
}

