/*
 * Decompiled with CFR 0.152.
 */
package leap.web.security.login;

import leap.core.annotation.Inject;
import leap.core.annotation.R;
import leap.core.security.Credentials;
import leap.core.web.RequestBase;
import leap.lang.Out;
import leap.lang.intercepting.State;
import leap.web.Request;
import leap.web.Response;
import leap.web.security.authc.credentials.CredentialsResolver;
import leap.web.security.login.LoginContext;
import leap.web.security.login.LoginHandler;

public class CredentialsResolvingHandler
implements LoginHandler {
    @Inject
    @R
    protected CredentialsResolver[] credentialsResolver;

    @Override
    public State handleLoginAuthentication(Request request, Response response, LoginContext context) throws Throwable {
        if (!context.isCredentialsResolved()) {
            Out out = new Out();
            for (CredentialsResolver resolver : this.credentialsResolver) {
                if (!resolver.resolveCredentials(context, (RequestBase)request, (Out<Credentials>)out)) continue;
                context.setCredentials((Credentials)out.getValue());
                break;
            }
        }
        return State.CONTINUE;
    }
}

