/*
 * Decompiled with CFR 0.152.
 */
package leap.web.security.login;

import leap.core.annotation.Inject;
import leap.core.security.Authentication;
import leap.lang.Out;
import leap.lang.intercepting.State;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import leap.web.Request;
import leap.web.Response;
import leap.web.security.DefaultSecurityContextHolder;
import leap.web.security.SecurityConfig;
import leap.web.security.SecurityInterceptor;
import leap.web.security.authc.AuthenticationManager;
import leap.web.security.authc.SimpleAuthentication;
import leap.web.security.login.LoginAjaxHandler;
import leap.web.security.login.LoginContext;
import leap.web.security.login.LoginHandler;
import leap.web.security.login.LoginManager;
import leap.web.security.login.LoginViewHandler;
import leap.web.security.permission.PermissionManager;

public class DefaultLoginManager
implements LoginManager {
    private static final Log log = LogFactory.get(DefaultLoginManager.class);
    @Inject
    protected SecurityConfig config;
    @Inject
    protected LoginHandler[] handlers;
    @Inject
    protected LoginAjaxHandler ajaxHandler;
    @Inject
    protected LoginViewHandler viewHandler;
    @Inject
    protected AuthenticationManager authcManager;
    @Inject
    protected PermissionManager permissionManager;

    @Override
    public boolean promoteLogin(Request request, Response response, LoginContext context) throws Throwable {
        for (SecurityInterceptor i : this.config.getInterceptors()) {
            if (!State.isIntercepted((State)i.prePromoteLogin(request, response, context))) continue;
            return true;
        }
        if (request.isAjax()) {
            log.debug("Promote login for ajax request");
            this.ajaxHandler.promoteLogin(request, response, context);
        } else {
            log.debug("Promote login");
            this.viewHandler.promoteLogin(request, response, context);
        }
        return true;
    }

    @Override
    public boolean handleLoginRequest(Request request, Response response, LoginContext context) throws Throwable {
        if (!this.isLoginRequest(request, response, context)) {
            return false;
        }
        request.setAcceptValidationError(Boolean.valueOf(true));
        if (this.isGotoLoginView(request, response, context)) {
            this.handleLoginView(request, response, context);
        } else {
            this.handleLoginAuthentication(request, response, context);
        }
        return true;
    }

    protected boolean isGotoLoginView(Request request, Response response, LoginContext context) {
        LoginHandler.HandleType type = request.isGet() ? LoginHandler.HandleType.VIEW : LoginHandler.HandleType.AUTHENTICATION;
        Out out = new Out();
        out.set((Object)type);
        for (LoginHandler handler : this.handlers) {
            handler.parseHandleType(request, response, context, (Out<LoginHandler.HandleType>)out);
        }
        return out.get() == LoginHandler.HandleType.VIEW;
    }

    @Override
    public void handleLoginSuccess(Request request, Response response, Authentication authc) throws Throwable {
        DefaultSecurityContextHolder context = new DefaultSecurityContextHolder(this.config, this.permissionManager, request);
        context.setAuthentication(authc);
        this.handleLoginSuccessView(request, response, context.getLoginContext());
    }

    protected void handleLoginView(Request request, Response response, LoginContext context) throws Throwable {
        for (LoginHandler handler : this.handlers) {
            if (!State.isIntercepted((State)handler.handleLoginView(request, response, context))) continue;
            return;
        }
        this.viewHandler.goLoginUrl(request, response, context);
    }

    protected void handleLoginSuccessView(Request request, Response response, LoginContext context) throws Throwable {
        if (request.isAjax()) {
            this.ajaxHandler.handleLoginSuccess(request, response, context);
        } else {
            this.viewHandler.handleLoginSuccess(request, response, context);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void handleLoginAuthentication(Request request, Response response, LoginContext context) throws Throwable {
        for (SecurityInterceptor securityInterceptor : this.config.getInterceptors()) {
            if (!State.isIntercepted((State)securityInterceptor.preLoginAuthentication(request, response, context))) continue;
            return;
        }
        if (!context.isAuthenticated() && !context.isError()) {
            for (LoginHandler loginHandler : this.handlers) {
                if (!State.isIntercepted((State)loginHandler.handleLoginAuthentication(request, response, context))) continue;
                return;
            }
        }
        if (context.isAuthenticated() && !context.isError()) {
            void var7_12;
            SimpleAuthentication authc = new SimpleAuthentication(context.getUser(), context.getCredentials());
            this.authcManager.loginImmediately(request, response, authc);
            SecurityInterceptor[] securityInterceptorArray = this.config.getInterceptors();
            int n = securityInterceptorArray.length;
            boolean bl = false;
            while (var7_12 < n) {
                SecurityInterceptor i = securityInterceptorArray[var7_12];
                if (State.isIntercepted((State)i.onLoginAuthenticationSuccess(request, response, context, authc))) {
                    return;
                }
                ++var7_12;
            }
            this.handleLoginSuccessView(request, response, context);
        } else {
            for (SecurityInterceptor securityInterceptor : this.config.getInterceptors()) {
                if (!State.isIntercepted((State)securityInterceptor.onLoginAuthenticationFailure(request, response, context))) continue;
                return;
            }
            if (request.isAjax()) {
                this.ajaxHandler.handleLoginFailure(request, response, context);
            } else {
                this.viewHandler.handleLoginFailure(request, response, context);
            }
        }
    }

    protected boolean isLoginRequest(Request request, Response response, LoginContext context) throws Throwable {
        return request.getPath().equals(this.config.getLoginAction());
    }
}

