/*
 * Decompiled with CFR 0.152.
 */
package leap.web.security.login;

import leap.core.annotation.Inject;
import leap.core.annotation.M;
import leap.lang.Strings;
import leap.lang.net.Urls;
import leap.web.AppListener;
import leap.web.Request;
import leap.web.Response;
import leap.web.UrlHandler;
import leap.web.security.SecurityConfig;
import leap.web.security.login.LoginContext;
import leap.web.security.login.LoginViewHandler;

public class DefaultLoginViewHandler
implements LoginViewHandler,
AppListener {
    @Inject
    @M
    protected SecurityConfig config;
    @Inject
    @M
    protected UrlHandler urlHandler;

    @Override
    public void promoteLogin(Request request, Response response, LoginContext context) throws Throwable {
        this.goLoginUrl(request, response, context);
    }

    @Override
    public void goLoginUrl(Request request, Response response, LoginContext context) throws Throwable {
        String loginUrl = this.getLoginUrl(context, request);
        String returnUrl = this.getReturnUrl(context, request, loginUrl);
        this.goLoginUrl(context, request, response, loginUrl, returnUrl);
    }

    @Override
    public void handleLoginSuccess(Request request, Response response, LoginContext context) throws Throwable {
        response.sendRedirect(this.getReturnUrl(context, request, null));
    }

    @Override
    public void handleLoginFailure(Request request, Response response, LoginContext context) throws Throwable {
        this.goLoginUrl(request, response, context);
    }

    protected void goLoginUrl(LoginContext context, Request request, Response response, String loginUrl, String returnUrl) throws Throwable {
        this.urlHandler.handleUrl(request, response, loginUrl, (url, info) -> {
            if (info.isRedirect()) {
                if (null == context.getLoginUrl() && null != returnUrl) {
                    return Urls.appendQueryParams((String)url, (String)this.config.getReturnUrlParameterName(), (String)returnUrl);
                }
            } else {
                request.setAttribute(context.getSecurityConfig().getReturnUrlParameterName(), (Object)returnUrl);
            }
            return url;
        });
    }

    protected String getLoginUrl(LoginContext context, Request request) {
        String loginUrl = context.getLoginUrl();
        if (null == loginUrl) {
            loginUrl = context.getSecurityConfig().getLoginUrl();
        }
        return loginUrl;
    }

    protected String getReturnUrl(LoginContext context, Request request, String loginUrl) {
        String returnUrl = context.getReturnUrl();
        if (null == returnUrl) {
            returnUrl = request.getParameter(this.config.getReturnUrlParameterName());
        }
        if (Strings.isEmpty((String)returnUrl)) {
            if (null != loginUrl) {
                String loginPath = Urls.removeQueryString((String)this.urlHandler.removePrefix(loginUrl));
                if (!request.getPath().equals(loginPath)) {
                    return request.getUriWithQueryString();
                }
            }
            return "/";
        }
        return returnUrl;
    }
}

