/*
 * Decompiled with CFR 0.152.
 */
package leap.web.security.logout;

import leap.core.annotation.Inject;
import leap.lang.intercepting.State;
import leap.web.Request;
import leap.web.Response;
import leap.web.security.DefaultSecurityContextHolder;
import leap.web.security.SecurityConfig;
import leap.web.security.SecurityInterceptor;
import leap.web.security.authc.AuthenticationManager;
import leap.web.security.logout.LogoutAjaxHandler;
import leap.web.security.logout.LogoutContext;
import leap.web.security.logout.LogoutHandler;
import leap.web.security.logout.LogoutManager;
import leap.web.security.logout.LogoutViewHandler;
import leap.web.security.permission.PermissionManager;

public class DefaultLogoutManager
implements LogoutManager {
    @Inject
    protected SecurityConfig config;
    @Inject
    protected LogoutHandler[] handlers;
    @Inject
    protected AuthenticationManager authcManager;
    @Inject
    protected LogoutViewHandler viewHandler;
    @Inject
    protected LogoutAjaxHandler ajaxHandler;
    @Inject
    protected PermissionManager permissionManager;

    @Override
    public boolean handleLogoutRequest(Request request, Response response, LogoutContext context) throws Throwable {
        if (!this.isLogoutRequest(request, response, context)) {
            return false;
        }
        this.logout(request, response, context);
        return true;
    }

    @Override
    public void logout(Request request, Response response) throws Throwable {
        DefaultSecurityContextHolder context = new DefaultSecurityContextHolder(this.config, this.permissionManager, request);
        this.logout(request, response, context.getLogoutContext());
    }

    @Override
    public void logout(Request request, Response response, LogoutContext context) throws Throwable {
        for (SecurityInterceptor securityInterceptor : this.config.getInterceptors()) {
            if (!State.isIntercepted((State)securityInterceptor.preLogout(request, response, context))) continue;
            return;
        }
        for (LogoutHandler logoutHandler : this.handlers) {
            if (!State.isIntercepted((State)logoutHandler.handleLogout(request, response, context))) continue;
            return;
        }
        this.authcManager.logoutImmediately(request, response);
        if (request.isAjax()) {
            this.ajaxHandler.handleLogoutSuccess(request, response, context);
        } else {
            this.viewHandler.handleLogoutSuccess(request, response, context);
        }
        for (SecurityInterceptor securityInterceptor : this.config.getInterceptors()) {
            if (!State.isIntercepted((State)securityInterceptor.postLogout(request, response, context))) continue;
            return;
        }
    }

    protected boolean isLogoutRequest(Request request, Response response, LogoutContext context) throws Throwable {
        return request.getPath().equals(this.config.getLogoutAction());
    }
}

