/*
 * Decompiled with CFR 0.152.
 */
package leap.web.security.logout;

import leap.lang.Strings;
import leap.lang.net.Urls;
import leap.web.Request;
import leap.web.Response;
import leap.web.security.logout.LogoutContext;
import leap.web.security.logout.LogoutViewHandler;

public class DefaultLogoutViewHandler
implements LogoutViewHandler {
    @Override
    public void handleLogoutSuccess(Request request, Response response, LogoutContext context) throws Throwable {
        this.gotoLocation(request, response, this.getReturnUrl(context, request));
    }

    protected void gotoLocation(Request request, Response response, String location) throws Throwable {
        if ((location = Urls.appendQueryParams((String)location, (String)"_t_", (String)(System.currentTimeMillis() + ""))).startsWith("forward:")) {
            request.forward(location.substring("forward:".length()));
            return;
        }
        if (location.startsWith("view:")) {
            request.forwardToView(location.substring("view:".length()));
            return;
        }
        if (location.startsWith("redirect:")) {
            response.sendRedirect(location.substring("redirect:".length()));
            return;
        }
        response.sendRedirect(location);
    }

    protected String getReturnUrl(LogoutContext context, Request request) {
        String returnUrl = context.getReturnUrl();
        if (null == returnUrl) {
            returnUrl = request.getParameter(context.getSecurityConfig().getReturnUrlParameterName());
        }
        if (Strings.isEmpty((String)returnUrl)) {
            returnUrl = context.getSecurityConfig().getLogoutSuccessUrl();
        }
        if (Strings.isEmpty((String)returnUrl)) {
            returnUrl = Strings.isEmpty((String)request.getContextPath()) ? "/" : request.getContextPath();
        }
        return returnUrl;
    }
}

