/*
 * Decompiled with CFR 0.152.
 */
package leap.web.security.path;

import leap.core.security.Authentication;
import leap.core.security.Authorization;
import leap.lang.Args;
import leap.lang.Arrays2;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import leap.lang.path.PathPattern;
import leap.web.Request;
import leap.web.route.Route;
import leap.web.security.SecurityFailureHandler;
import leap.web.security.authc.AuthenticationContext;
import leap.web.security.authz.AuthorizationContext;
import leap.web.security.path.SecuredPath;
import leap.web.security.permission.PermissionManager;

public class DefaultSecuredPath
implements SecuredPath {
    private static final Log log = LogFactory.get(DefaultSecuredPath.class);
    protected final Route route;
    protected final PathPattern pattern;
    protected final Boolean allowAnonymous;
    protected final Boolean allowClientOnly;
    protected final Boolean allowRememberMe;
    protected final SecurityFailureHandler failureHandler;
    protected final String[] permissions;
    protected final String[] roles;

    public DefaultSecuredPath(Route route, PathPattern pattern, Boolean allowAnonymous, Boolean allowClientOnly, Boolean allowRememberMe, SecurityFailureHandler failureHandler, String[] permissions, String[] roles) {
        Args.notNull((Object)pattern, (String)"path pattern");
        this.route = route;
        this.pattern = pattern;
        this.allowAnonymous = allowAnonymous;
        this.allowClientOnly = allowClientOnly;
        this.allowRememberMe = allowRememberMe;
        this.failureHandler = failureHandler;
        this.permissions = permissions;
        this.roles = roles;
    }

    @Override
    public Route getRoute() {
        return this.route;
    }

    @Override
    public PathPattern getPattern() {
        return this.pattern;
    }

    @Override
    public Boolean getAllowAnonymous() {
        return this.allowAnonymous;
    }

    @Override
    public Boolean getAllowClientOnly() {
        return this.allowClientOnly;
    }

    @Override
    public Boolean getAllowRememberMe() {
        return this.allowRememberMe;
    }

    @Override
    public SecurityFailureHandler getFailureHandler() {
        return this.failureHandler;
    }

    @Override
    public String[] getPermissions() {
        return this.permissions;
    }

    @Override
    public String[] getRoles() {
        return this.roles;
    }

    @Override
    public boolean checkAuthentication(Request request, AuthenticationContext context) {
        if (this.isAllowAnonymous()) {
            return true;
        }
        Authentication authc = context.getAuthentication();
        if (authc == null || !authc.isAuthenticated()) {
            log.debug("path [{}] : not authenticated, deny the request.", new Object[]{this.pattern});
            return false;
        }
        if (authc.isRememberMe() && !this.isAllowRememberMe()) {
            log.debug("path [{}] : remember-me authentication not allowed.", new Object[]{this.pattern});
            return false;
        }
        if (authc.isClientOnly() && !this.isAllowClientOnly()) {
            log.debug("path [{}] : client-only authentication not allowed.", new Object[]{this.pattern});
            return false;
        }
        return true;
    }

    @Override
    public boolean checkAuthorization(Request request, AuthorizationContext context) {
        Authentication authc = context.getAuthentication();
        Authorization authz = context.getAuthorization();
        if (this.roles.length > 0) {
            boolean allow = false;
            String[] grantedRoles = authc.getRoles();
            if (null != grantedRoles && grantedRoles.length > 0) {
                allow = Arrays2.containsAny((String[])grantedRoles, (String[])this.roles);
            }
            if (!allow) {
                allow = authz.hasAnyRole(this.roles);
            }
            if (!allow) {
                return false;
            }
        }
        if (this.permissions.length > 0) {
            PermissionManager pm = context.getPermissionManager();
            boolean allow = false;
            String[] grantedPermissions = authc.getPermissions();
            if (null != grantedPermissions && grantedPermissions.length > 0) {
                allow = pm.checkPermissionImpliesAll(grantedPermissions, this.permissions);
            }
            if (!allow) {
                allow = authz.hasAllPermission(this.permissions);
            }
            if (!allow) {
                return false;
            }
        }
        return true;
    }

    @Override
    public int compareTo(SecuredPath o) {
        return COMPARATOR.compare(this, o);
    }
}

