/*
 * Decompiled with CFR 0.152.
 */
package leap.web.security.path;

import java.util.ArrayList;
import java.util.List;
import leap.lang.Arrays2;
import leap.lang.Collections2;
import leap.lang.path.AntPathPattern;
import leap.lang.path.PathPattern;
import leap.web.route.Route;
import leap.web.security.SecurityFailureHandler;
import leap.web.security.path.DefaultSecuredPath;
import leap.web.security.path.SecuredPath;
import leap.web.security.path.SecuredPathBuilder;

public class DefaultSecuredPathBuilder
implements SecuredPathBuilder {
    protected Route route;
    protected PathPattern pattern;
    protected Boolean allowAnonymous = null;
    protected Boolean allowClientOnly = null;
    protected Boolean allowRememberMe = true;
    protected SecurityFailureHandler failureHandler = null;
    protected List<String> permissions = new ArrayList<String>();
    protected List<String> roles = new ArrayList<String>();

    public DefaultSecuredPathBuilder() {
    }

    public DefaultSecuredPathBuilder(String path) {
        this.path(path);
    }

    public DefaultSecuredPathBuilder(PathPattern pattern) {
        this.pattern = pattern;
    }

    public DefaultSecuredPathBuilder(Route route) {
        this.route = route;
        this.pattern = route.getPathTemplate();
    }

    public DefaultSecuredPathBuilder(SecuredPath path) {
        this.route = path.getRoute();
        this.pattern = path.getPattern();
        this.allowAnonymous = path.getAllowAnonymous();
        this.allowClientOnly = path.getAllowClientOnly();
        this.allowRememberMe = path.getAllowRememberMe();
        this.failureHandler = path.getFailureHandler();
        Collections2.addAll(this.permissions, (Object[])path.getPermissions());
        Collections2.addAll(this.roles, (Object[])path.getRoles());
    }

    public Route getRoute() {
        return this.route;
    }

    public SecuredPathBuilder path(String pattern) {
        return this.setPattern((PathPattern)new AntPathPattern(pattern));
    }

    @Override
    public PathPattern getPattern() {
        return this.pattern;
    }

    @Override
    public SecuredPathBuilder setPattern(PathPattern pattern) {
        this.pattern = pattern;
        return this;
    }

    @Override
    public Boolean getAllowAnonymous() {
        return this.allowAnonymous;
    }

    @Override
    public Boolean getAllowRememberMe() {
        return this.allowRememberMe;
    }

    @Override
    public Boolean getAllowClientOnly() {
        return this.allowClientOnly;
    }

    @Override
    public DefaultSecuredPathBuilder setAllowAnonymous(Boolean allowAnonymous) {
        this.allowAnonymous = allowAnonymous;
        return this;
    }

    @Override
    public DefaultSecuredPathBuilder setAllowClientOnly(Boolean allowClientOnly) {
        this.allowClientOnly = allowClientOnly;
        return this;
    }

    @Override
    public SecuredPathBuilder setAllowRememberMe(Boolean denyRememberMe) {
        this.allowRememberMe = denyRememberMe;
        return this;
    }

    public SecurityFailureHandler getFailureHandler() {
        return this.failureHandler;
    }

    @Override
    public SecuredPathBuilder setFailureHandler(SecurityFailureHandler failureHandler) {
        this.failureHandler = failureHandler;
        return this;
    }

    @Override
    public SecuredPathBuilder setPermissionsAllowed(String ... permissions) {
        this.permissions.clear();
        Collections2.addAll(this.permissions, (Object[])permissions);
        return this;
    }

    @Override
    public SecuredPathBuilder setRolesAllowed(String ... roles) {
        this.roles.clear();
        Collections2.addAll(this.roles, (Object[])roles);
        return this;
    }

    @Override
    public SecuredPathBuilder addPermissionsAllowed(String ... permissions) {
        Collections2.addAll(this.permissions, (Object[])permissions);
        return this;
    }

    @Override
    public SecuredPathBuilder addRolesAllowed(String ... roles) {
        Collections2.addAll(this.roles, (Object[])roles);
        return this;
    }

    public SecuredPath build() {
        return new DefaultSecuredPath(this.route, this.pattern, this.allowAnonymous, this.allowClientOnly, this.allowRememberMe, this.failureHandler, this.permissions.toArray(Arrays2.EMPTY_STRING_ARRAY), this.roles.toArray(Arrays2.EMPTY_STRING_ARRAY));
    }
}

