/*
 * Decompiled with CFR 0.152.
 */
package leap.web.security.path;

import leap.lang.path.PathPattern;
import leap.web.route.Route;
import leap.web.security.SecurityFailureHandler;
import leap.web.security.path.DefaultSecuredPathBuilder;
import leap.web.security.path.DefaultSecuredPaths;
import leap.web.security.path.SecuredPath;
import leap.web.security.path.SecuredPathBuilder;
import leap.web.security.path.SecuredPathConfigurator;

public class DefaultSecuredPathConfigurator
implements SecuredPathConfigurator {
    protected final DefaultSecuredPaths paths;
    protected final SecuredPathBuilder path;

    public DefaultSecuredPathConfigurator(DefaultSecuredPaths paths, Route route) {
        this.paths = paths;
        this.path = new DefaultSecuredPathBuilder(route);
    }

    public DefaultSecuredPathConfigurator(DefaultSecuredPaths paths, PathPattern pp) {
        this.paths = paths;
        this.path = new DefaultSecuredPathBuilder(pp);
    }

    public DefaultSecuredPathConfigurator(DefaultSecuredPaths paths, SecuredPath old) {
        this.paths = paths;
        this.path = new DefaultSecuredPathBuilder(old);
    }

    public DefaultSecuredPathConfigurator(DefaultSecuredPaths paths, SecuredPathBuilder sp) {
        this.paths = paths;
        this.path = sp;
    }

    @Override
    public SecuredPathConfigurator setAllowAnonymous(Boolean allow) {
        this.path.setAllowAnonymous(allow);
        return this;
    }

    @Override
    public SecuredPathConfigurator setAllowRememberMe(Boolean allow) {
        this.path.setAllowRememberMe(allow);
        return this;
    }

    @Override
    public SecuredPathConfigurator setAllowClientOnly(Boolean allow) {
        this.path.setAllowClientOnly(allow);
        return this;
    }

    @Override
    public SecuredPathConfigurator setFailureHandler(SecurityFailureHandler handler) {
        this.path.setFailureHandler(handler);
        return this;
    }

    @Override
    public Boolean getAllowAnonymous() {
        return this.path.getAllowAnonymous();
    }

    @Override
    public Boolean getAllowRememberMe() {
        return this.path.getAllowRememberMe();
    }

    @Override
    public Boolean getAllowClientOnly() {
        return this.path.getAllowClientOnly();
    }

    @Override
    public SecuredPathConfigurator setPermissionsAllowed(String ... permissions) {
        this.path.setPermissionsAllowed(permissions);
        return this;
    }

    @Override
    public SecuredPathConfigurator setRolesAllowed(String ... roles) {
        this.path.setRolesAllowed(roles);
        return this;
    }

    @Override
    public SecuredPath apply() {
        SecuredPath p = (SecuredPath)this.path.build();
        this.paths.apply(this, p);
        return p;
    }
}

