/*
 * Decompiled with CFR 0.152.
 */
package leap.web.security.path;

import leap.core.annotation.Inject;
import leap.core.annotation.M;
import leap.core.cache.Cache;
import leap.core.cache.SimpleLRUCache;
import leap.core.web.RequestBase;
import leap.lang.Strings;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import leap.lang.path.PathPattern;
import leap.web.Request;
import leap.web.security.SecurityConfig;
import leap.web.security.SecurityContextHolder;
import leap.web.security.path.DefaultSecuredPathBuilder;
import leap.web.security.path.SecuredPath;
import leap.web.security.path.SecuredPathSource;

public class DefaultSecuredPathSource
implements SecuredPathSource {
    private static final Log log = LogFactory.get(DefaultSecuredPathSource.class);
    private static final PathPattern ANY_PATTERN = new PathPattern(){

        public boolean matches(String path) {
            return true;
        }

        public String pattern() {
            return "/**";
        }

        public String toString() {
            return this.pattern();
        }
    };
    private static final SecuredPath ANY = (SecuredPath)new DefaultSecuredPathBuilder().setPattern(ANY_PATTERN).build();
    private static final SecuredPath NULL = (SecuredPath)new DefaultSecuredPathBuilder().setPattern(ANY_PATTERN).build();
    @Inject
    @M
    protected SecurityConfig config;
    protected Cache<String, SecuredPath> cachedPaths = new SimpleLRUCache(1024);

    @Override
    public SecuredPath getSecuredPath(SecurityContextHolder context, Request request) {
        String cacheKey = this.genCacheKey(request);
        SecuredPath securedPath = (SecuredPath)this.cachedPaths.get((Object)cacheKey);
        if (null != securedPath) {
            return securedPath == NULL ? null : securedPath;
        }
        log.debug("Matching request {} ...", new Object[]{request.getPath()});
        for (SecuredPath p : this.config.getSecuredPaths()) {
            if (this.matches(p, request)) {
                log.debug("Matches -> {} {}", new Object[]{p.getRoute() == null ? "*" : p.getRoute().getMethod(), p.getPattern()});
                this.cachedPaths.put((Object)cacheKey, (Object)p);
                return p;
            }
            log.debug("Not matches -> {}", new Object[]{p.getPattern()});
        }
        if (this.config.isAuthenticateAnyRequests()) {
            this.cachedPaths.put((Object)request.getPath(), (Object)ANY);
            return ANY;
        }
        this.cachedPaths.put((Object)request.getPath(), (Object)NULL);
        return null;
    }

    private boolean matches(SecuredPath p, Request request) {
        return p.matches((RequestBase)request) && (p.getRoute() == null || Strings.equals((String)p.getRoute().getMethod(), (String)"*") || Strings.equalsIgnoreCase((String)p.getRoute().getMethod(), (String)request.getMethod()));
    }

    private String genCacheKey(Request request) {
        return request.getMethod() + "$" + request.getPath();
    }
}

