/*
 * Decompiled with CFR 0.152.
 */
package leap.web.security.path;

import java.util.Iterator;
import java.util.TreeMap;
import leap.lang.Args;
import leap.lang.path.AntPathPattern;
import leap.lang.path.PathPattern;
import leap.web.Request;
import leap.web.route.Route;
import leap.web.security.SecurityFailureHandler;
import leap.web.security.authc.AuthenticationContext;
import leap.web.security.authz.AuthorizationContext;
import leap.web.security.path.DefaultSecuredPathConfigurator;
import leap.web.security.path.SecuredPath;
import leap.web.security.path.SecuredPathConfigurator;
import leap.web.security.path.SecuredPaths;

public class DefaultSecuredPaths
implements SecuredPaths {
    protected final TreeMap<PathPattern, PathEntry> paths = new TreeMap(PathPattern.DEFAULT_COMPARATOR);

    public boolean isEmpty() {
        return this.paths.isEmpty();
    }

    @Override
    public Iterator<SecuredPath> iterator() {
        Iterator<SecuredPath> it = this.paths.values().iterator();
        return it;
    }

    @Override
    public SecuredPathConfigurator of(String path) {
        Args.notEmpty((String)path, (String)"path");
        return this.configurator((PathPattern)new AntPathPattern(path));
    }

    @Override
    public SecuredPathConfigurator of(PathPattern pp) {
        Args.notNull((Object)pp, (String)"path pattern");
        return this.configurator(pp);
    }

    @Override
    public SecuredPathConfigurator of(Route route) {
        Args.notNull((Object)route, (String)"route");
        return this.configurator(route);
    }

    @Override
    public SecuredPathConfigurator get(Route route) {
        PathEntry pe = this.paths.get(route.getPathTemplate());
        if (null == pe) {
            return null;
        }
        return pe.configurator;
    }

    protected SecuredPathConfigurator configurator(Route route) {
        PathEntry pe = this.paths.get(route.getPathTemplate());
        if (null == pe) {
            return new DefaultSecuredPathConfigurator(this, route);
        }
        if (null == pe.configurator) {
            pe.configurator = new DefaultSecuredPathConfigurator(this, pe);
        }
        return pe.configurator;
    }

    protected SecuredPathConfigurator configurator(PathPattern pp) {
        PathEntry pe = this.paths.get(pp);
        if (null == pe) {
            return new DefaultSecuredPathConfigurator(this, pp);
        }
        if (null == pe.configurator) {
            pe.configurator = new DefaultSecuredPathConfigurator(this, pe);
        }
        return pe.configurator;
    }

    @Override
    public SecuredPaths apply(SecuredPath p) {
        Args.notNull((Object)p);
        this.paths.put(p.getPattern(), new PathEntry(p));
        return this;
    }

    @Override
    public SecuredPaths apply(String path, boolean allowAnonymous) {
        this.of(path).setAllowAnonymous(allowAnonymous).apply();
        return this;
    }

    @Override
    public SecuredPath remove(String path) {
        Args.notEmpty((String)path, (String)"path");
        return this.paths.remove(new AntPathPattern(path));
    }

    public void apply(SecuredPathConfigurator c, SecuredPath p) {
        this.paths.put(p.getPattern(), new PathEntry(p, c));
    }

    protected static final class PathEntry
    implements SecuredPath {
        SecuredPath path;
        SecuredPathConfigurator configurator;

        PathEntry(SecuredPath p) {
            this.path = p;
        }

        PathEntry(SecuredPath p, SecuredPathConfigurator c) {
            this.path = p;
            this.configurator = c;
        }

        @Override
        public Route getRoute() {
            return this.path.getRoute();
        }

        @Override
        public PathPattern getPattern() {
            return this.path.getPattern();
        }

        @Override
        public Boolean getAllowAnonymous() {
            return this.path.getAllowAnonymous();
        }

        @Override
        public Boolean getAllowClientOnly() {
            return this.path.getAllowClientOnly();
        }

        @Override
        public Boolean getAllowRememberMe() {
            return this.path.getAllowRememberMe();
        }

        @Override
        public SecurityFailureHandler getFailureHandler() {
            return this.path.getFailureHandler();
        }

        @Override
        public String[] getPermissions() {
            return this.path.getPermissions();
        }

        @Override
        public String[] getRoles() {
            return this.path.getRoles();
        }

        @Override
        public boolean checkAuthentication(Request request, AuthenticationContext context) {
            return this.path.checkAuthentication(request, context);
        }

        @Override
        public boolean checkAuthorization(Request request, AuthorizationContext context) {
            return this.path.checkAuthorization(request, context);
        }

        @Override
        public int compareTo(SecuredPath o) {
            return this.path.compareTo(o);
        }

        public String toString() {
            return this.path.toString();
        }
    }
}

