/*
 * Decompiled with CFR 0.152.
 */
package leap.web.security.path;

import leap.lang.Arrays2;
import leap.lang.path.PathPattern;
import leap.web.Request;
import leap.web.route.Route;
import leap.web.security.SecurityFailureHandler;
import leap.web.security.authc.AuthenticationContext;
import leap.web.security.authz.AuthorizationContext;
import leap.web.security.path.DefaultSecuredPathBuilder;
import leap.web.security.path.SecuredPath;

public class MergedSecuredPath
implements SecuredPath {
    private final Route route;
    private final SecuredPath merged;

    public MergedSecuredPath(Route route, SecuredPath p1, SecuredPath p2) {
        this.route = route;
        this.merged = this.merge(p1, p2);
    }

    @Override
    public Route getRoute() {
        return this.route;
    }

    @Override
    public PathPattern getPattern() {
        return this.route.getPathTemplate();
    }

    @Override
    public Boolean getAllowAnonymous() {
        return this.merged.getAllowAnonymous();
    }

    @Override
    public Boolean getAllowClientOnly() {
        return this.merged.getAllowClientOnly();
    }

    @Override
    public Boolean getAllowRememberMe() {
        return this.merged.getAllowRememberMe();
    }

    @Override
    public String[] getPermissions() {
        return this.merged.getPermissions();
    }

    @Override
    public String[] getRoles() {
        return this.merged.getRoles();
    }

    @Override
    public SecurityFailureHandler getFailureHandler() {
        return this.merged.getFailureHandler();
    }

    @Override
    public boolean checkAuthentication(Request request, AuthenticationContext context) {
        return this.merged.checkAuthentication(request, context);
    }

    @Override
    public boolean checkAuthorization(Request request, AuthorizationContext context) {
        return this.merged.checkAuthorization(request, context);
    }

    @Override
    public int compareTo(SecuredPath o) {
        return this.merged.compareTo(o);
    }

    private SecuredPath merge(SecuredPath p1, SecuredPath p2) {
        DefaultSecuredPathBuilder spb = new DefaultSecuredPathBuilder(this.route);
        if (null != p1.getAllowAnonymous()) {
            spb.setAllowAnonymous(p1.getAllowAnonymous());
        } else {
            spb.setAllowAnonymous(p2.getAllowAnonymous());
        }
        if (null != p1.getAllowClientOnly()) {
            spb.setAllowClientOnly(p1.getAllowClientOnly());
        } else {
            spb.setAllowClientOnly(p2.getAllowClientOnly());
        }
        if (null != p1.getAllowRememberMe()) {
            spb.setAllowRememberMe(p1.getAllowRememberMe());
        } else {
            spb.setAllowRememberMe(p2.getAllowRememberMe());
        }
        if (!Arrays2.isEmpty((Object[])p1.getPermissions())) {
            spb.setPermissionsAllowed(p1.getPermissions());
        } else {
            spb.setPermissionsAllowed(p2.getPermissions());
        }
        if (!Arrays2.isEmpty((Object[])p1.getRoles())) {
            spb.setRolesAllowed(p1.getRoles());
        } else {
            spb.setRolesAllowed(p2.getRoles());
        }
        if (null != p1.getFailureHandler()) {
            spb.setFailureHandler(p1.getFailureHandler());
        } else {
            spb.setFailureHandler(p2.getFailureHandler());
        }
        return (SecuredPath)spb.build();
    }
}

