/*
 * Decompiled with CFR 0.152.
 */
package leap.web.security.path;

import java.util.Comparator;
import leap.core.web.RequestBase;
import leap.core.web.RequestMatcher;
import leap.lang.path.PathPattern;
import leap.web.Request;
import leap.web.route.Route;
import leap.web.security.SecurityFailureHandler;
import leap.web.security.authc.AuthenticationContext;
import leap.web.security.authz.AuthorizationContext;

public interface SecuredPath
extends RequestMatcher,
Comparable<SecuredPath> {
    public static final Comparator<SecuredPath> COMPARATOR = (p1, p2) -> {
        if (p1 == null && p2 == null) {
            return 0;
        }
        if (p1 == null) {
            return 1;
        }
        if (p2 == null) {
            return -1;
        }
        int i = p1.getPattern().pattern().length() - p2.getPattern().pattern().length();
        if (i != 0) {
            return i;
        }
        return -1;
    };

    public Route getRoute();

    public PathPattern getPattern();

    public Boolean getAllowAnonymous();

    default public boolean isAllowAnonymous() {
        return this.getAllowAnonymous() == Boolean.TRUE;
    }

    default public boolean isDenyAnonymous() {
        return this.getAllowAnonymous() == Boolean.FALSE;
    }

    public Boolean getAllowClientOnly();

    default public boolean isAllowClientOnly() {
        return this.getAllowClientOnly() == Boolean.TRUE;
    }

    default public boolean isDenyClientOnly() {
        return this.getAllowClientOnly() == Boolean.FALSE;
    }

    public Boolean getAllowRememberMe();

    default public boolean isAllowRememberMe() {
        return this.getAllowRememberMe() == Boolean.TRUE;
    }

    default public boolean isDenyRememberMe() {
        return this.getAllowRememberMe() == Boolean.FALSE;
    }

    public String[] getPermissions();

    public String[] getRoles();

    public SecurityFailureHandler getFailureHandler();

    default public boolean matches(RequestBase request) {
        return this.getPattern().matches(request.getPath());
    }

    default public boolean matches(String path) {
        return this.getPattern().matches(path);
    }

    public boolean checkAuthentication(Request var1, AuthenticationContext var2);

    public boolean checkAuthorization(Request var1, AuthorizationContext var2);
}

