/*
 * Decompiled with CFR 0.152.
 */
package leap.web.security.user;

import leap.core.annotation.Inject;
import leap.core.security.Authentication;
import leap.core.security.Credentials;
import leap.core.security.UserPrincipal;
import leap.lang.Result;
import leap.web.security.SecurityConfig;
import leap.web.security.authc.SimpleAuthentication;
import leap.web.security.user.TrustedLoginNameCredentials;
import leap.web.security.user.TrustedUserIdCredentials;
import leap.web.security.user.UserDetails;
import leap.web.security.user.UserManager;

public class DefaultUserManager
implements UserManager {
    @Inject
    protected SecurityConfig sc;

    @Override
    public UserDetails getUserDetails(UserPrincipal user) {
        if (user instanceof UserDetails) {
            return (UserDetails)user;
        }
        return this.sc.getUserStore().loadUserDetailsById(user.getId());
    }

    @Override
    public UserDetails loadUserDetails(String userId) {
        return this.sc.getUserStore().loadUserDetailsById(userId);
    }

    @Override
    public Result<Authentication> createAuthenticationByUsername(String username) {
        UserDetails details = this.sc.getUserStore().loadUserDetailsByLoginName(username);
        if (null == details) {
            return Result.empty();
        }
        return Result.of((Object)new SimpleAuthentication(details, (Credentials)new TrustedLoginNameCredentials(username)));
    }

    @Override
    public Result<Authentication> createAuthenticationByUserId(String userid) {
        UserDetails details = this.sc.getUserStore().loadUserDetailsByIdString(userid);
        if (null == details) {
            return Result.empty();
        }
        return Result.of((Object)new SimpleAuthentication(details, (Credentials)new TrustedUserIdCredentials(userid)));
    }
}

