/*
 * Decompiled with CFR 0.152.
 */
package leap.web.security.user;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import leap.web.security.user.UserDetails;
import leap.web.security.user.UserStore;

public class InMemoryUserStore
implements UserStore {
    private final Map<String, User> users = new ConcurrentHashMap<String, User>();

    @Override
    public UserDetails loadUserDetailsById(Object userId) {
        return this.users.get((String)userId);
    }

    @Override
    public UserDetails loadUserDetailsByLoginName(String username) {
        return this.users.get(username);
    }

    public InMemoryUserStore add(String username, String encryptedPassword) {
        this.users.put(username, new User(username, encryptedPassword));
        return this;
    }

    public InMemoryUserStore add(User user) {
        this.users.put(user.getLoginName(), user);
        return this;
    }

    public User get(String username) {
        return this.users.get(username);
    }

    public static final class User
    implements UserDetails {
        protected String name;
        protected String loginName;
        protected String password;
        protected boolean enabled = true;

        public User() {
        }

        public User(String username, String password) {
            this.name = username;
            this.loginName = username;
            this.password = password;
        }

        public Object getId() {
            return this.loginName;
        }

        public String getName() {
            return this.name;
        }

        public String getLoginName() {
            return this.loginName;
        }

        @Override
        public String getPassword() {
            return this.password;
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setLoginName(String loginName) {
            this.loginName = loginName;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

