/*
 * Decompiled with CFR 0.152.
 */
package leap.web.security.user;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import leap.core.BeanFactory;
import leap.core.annotation.Inject;
import leap.core.ioc.PostCreateBean;
import leap.core.security.Authentication;
import leap.core.security.Credentials;
import leap.core.security.UserPrincipal;
import leap.core.security.token.TokenCredentials;
import leap.core.security.token.jwt.JwtSigner;
import leap.core.security.token.jwt.JwtVerifier;
import leap.core.security.token.jwt.MacSigner;
import leap.lang.Out;
import leap.lang.Strings;
import leap.web.Request;
import leap.web.Response;
import leap.web.security.SecurityConfig;
import leap.web.security.authc.AuthenticationException;
import leap.web.security.authc.TokenAuthenticator;
import leap.web.security.authc.credentials.CredentialsAuthenticationContext;
import leap.web.security.user.UserDetails;
import leap.web.security.user.UsernameBasedTokenAuthenticator;

public class JwtTokenAuthenticator
extends UsernameBasedTokenAuthenticator
implements TokenAuthenticator,
PostCreateBean {
    public static final String CLAIM_NAME = "name";
    public static final String JWT_ID = "jti";
    @Inject
    protected SecurityConfig config;
    protected JwtSigner signer;
    protected JwtVerifier verifier;

    @Override
    public String generateAuthenticationToken(Request request, Response response, Authentication authc) {
        return this.signer.sign(this.createClaims(authc));
    }

    @Override
    public boolean authenticate(CredentialsAuthenticationContext context, Credentials credentials, Out<UserPrincipal> user) throws AuthenticationException {
        if (credentials instanceof TokenCredentials) {
            String token = ((TokenCredentials)credentials).getToken();
            Map claims = this.verifier.verify(token);
            String username = (String)claims.get(CLAIM_NAME);
            String jti = (String)claims.get(JWT_ID);
            if (Strings.isEmpty((String)username) || Strings.isEmpty((String)jti)) {
                return false;
            }
            UserDetails details = this.resolveUserDetails(context, username, claims);
            if (null == details) {
                return false;
            }
            user.set((Object)details);
            return true;
        }
        return false;
    }

    @Override
    protected Map<String, Object> createDefaultClaims(Authentication auth) {
        UserPrincipal user = auth.getUser();
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put(JWT_ID, UUID.randomUUID().toString());
        claims.put(CLAIM_NAME, user.getLoginName());
        return claims;
    }

    public void postCreate(BeanFactory factory) throws Throwable {
        if (null == this.signer) {
            this.signer = new MacSigner(this.config.getSecret(), this.config.getDefaultAuthenticationExpires());
            this.verifier = (JwtVerifier)this.signer;
        }
    }

    public JwtSigner getSigner() {
        return this.signer;
    }

    public void setSigner(JwtSigner tokenSigner) {
        this.signer = tokenSigner;
    }

    public JwtVerifier getVerifier() {
        return this.verifier;
    }

    public void setVerifier(JwtVerifier tokenVerifier) {
        this.verifier = tokenVerifier;
    }
}

