/*
 * Decompiled with CFR 0.152.
 */
package leap.web.security.user;

import java.util.Map;
import leap.core.annotation.Inject;
import leap.core.validation.ValidationContext;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import leap.web.security.SecurityConfig;
import leap.web.security.user.UserDetails;

public abstract class UsernameBasedAuthenticator {
    private static final Log log = LogFactory.get(UsernameBasedAuthenticator.class);
    public static final String USER_NOT_FOUND_MESSAGE_KEY = "errors.user_not_found";
    public static final String USER_NOT_ENABLED_MESSAGE_KEY = "errors.user_not_enabled";
    @Inject
    protected SecurityConfig sc;

    protected UserDetails resolveUserDetails(ValidationContext context, String username, Map<String, Object> params) {
        UserDetails details = this.sc.getUserStore().loadUserDetailsByLoginName(username);
        if (null == details) {
            log.debug("User '{}' not found", new Object[]{username});
            context.validation().addError("username", USER_NOT_FOUND_MESSAGE_KEY, "User not found");
            return null;
        }
        if (!details.isEnabled()) {
            log.debug("User '{}' was disabled", new Object[]{username});
            context.validation().addError("username", USER_NOT_ENABLED_MESSAGE_KEY, "User was disabled");
            return null;
        }
        return details;
    }
}

