/*
 * Decompiled with CFR 0.152.
 */
package leap.web.security.user;

import leap.core.annotation.Inject;
import leap.core.security.Credentials;
import leap.core.security.UserPrincipal;
import leap.lang.Out;
import leap.lang.Strings;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import leap.web.security.SecurityConfig;
import leap.web.security.authc.AuthenticationException;
import leap.web.security.authc.credentials.CredentialsAuthenticationContext;
import leap.web.security.authc.credentials.CredentialsAuthenticator;
import leap.web.security.user.UserDetails;
import leap.web.security.user.UsernameBasedAuthenticator;
import leap.web.security.user.UsernamePasswordCredentials;

public class UsernamePasswordAuthenticator
extends UsernameBasedAuthenticator
implements CredentialsAuthenticator {
    private static final Log log = LogFactory.get(UsernamePasswordAuthenticator.class);
    public static final String INCORRECT_PASSWORD_MESSAGE_KEY = "errors.incorrect_password";
    @Inject
    protected SecurityConfig sc;

    @Override
    public boolean authenticate(CredentialsAuthenticationContext context, Credentials credentials, Out<UserPrincipal> principal) throws AuthenticationException {
        if (credentials instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials usernamePassword = (UsernamePasswordCredentials)credentials;
            UserDetails details = this.resolveUserDetails(context, usernamePassword.getUsername(), usernamePassword.getParameters());
            if (null == details) {
                return true;
            }
            String rawPassword = Strings.nullToEmpty((String)usernamePassword.getPassword());
            if (!this.sc.getPasswordEncoder().matches(rawPassword, details.getPassword())) {
                log.debug("Incorrect password of user '{}'", new Object[]{usernamePassword.getUsername()});
                context.validation().addError("password", INCORRECT_PASSWORD_MESSAGE_KEY, "Incorrect password");
            } else {
                principal.set((Object)details);
            }
            return true;
        }
        return false;
    }
}

