/*
 * Decompiled with CFR 0.152.
 */
package leap.web.security.user;

import java.io.IOException;
import javax.servlet.ServletException;
import leap.core.security.Credentials;
import leap.core.web.RequestBase;
import leap.lang.Out;
import leap.lang.http.HTTP;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import leap.web.security.authc.AuthenticationContext;
import leap.web.security.authc.credentials.CredentialsResolver;
import leap.web.security.user.SimpleUsernamePasswordCredentials;

public class UsernamePasswordResolver
implements CredentialsResolver {
    private static final Log log = LogFactory.get(UsernamePasswordResolver.class);
    protected String usernameParameter = "username";
    protected String passwordParameter = "password";
    protected boolean passwordRequired = true;

    public String getUsernameParameter() {
        return this.usernameParameter;
    }

    public void setUsernameParameter(String usernameParameter) {
        this.usernameParameter = usernameParameter;
    }

    public String getPasswordParameter() {
        return this.passwordParameter;
    }

    public void setPasswordParameter(String passwordParameter) {
        this.passwordParameter = passwordParameter;
    }

    public boolean isPasswordRequired() {
        return this.passwordRequired;
    }

    public void setPasswordRequired(boolean passwordRequired) {
        this.passwordRequired = passwordRequired;
    }

    @Override
    public boolean resolveCredentials(AuthenticationContext context, RequestBase request, Out<Credentials> out) throws ServletException, IOException {
        if (request.isMethod(HTTP.Method.POST) && request.hasParameter(this.usernameParameter)) {
            String username = request.getParameter(this.usernameParameter);
            if (context.validation().required(this.usernameParameter, (Object)username).hasErrors()) {
                return true;
            }
            context.setIdentity(username);
            String password = request.getParameter(this.passwordParameter);
            if (this.passwordRequired && context.validation().required(this.passwordParameter, (Object)password).hasErrors()) {
                return true;
            }
            log.debug("Resolved 'UsernamePasswordCredentials' : [username={}]", new Object[]{username});
            out.set((Object)new SimpleUsernamePasswordCredentials(username, password));
            return true;
        }
        return false;
    }
}

