/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.framework.ui.component.infotool;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.details.Details;
import com.vaadin.flow.component.details.DetailsVariant;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.router.AfterNavigationEvent;
import com.vaadin.flow.router.AfterNavigationObserver;
import com.vaadin.flow.router.Location;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.linkki.core.binding.manager.UiUpdateObserver;
import org.linkki.core.vaadin.component.base.LinkkiText;
import org.linkki.framework.ui.component.infotool.InfoTool;
import org.linkki.util.Sequence;
import org.linkki.util.StreamUtil;

public class InfoToolsComponent<T extends InfoTool>
extends VerticalLayout
implements UiUpdateObserver,
AfterNavigationObserver {
    public static final String QUERY_PARAM = "tools";
    protected static final String NO_TOOL_OPEN = "0";
    private static final long serialVersionUID = 1L;
    private final Sequence<T> tools;
    private final Sequence<T> defaultTools;

    public InfoToolsComponent(Sequence<T> tools, Sequence<T> defaultTools) {
        this.tools = tools;
        this.defaultTools = defaultTools;
        this.setWidthFull();
        this.setPadding(true);
        StreamUtil.stream(tools).distinct().map(this::createTool).forEach(xva$0 -> this.add(new Component[]{xva$0}));
        this.uiUpdated();
    }

    protected Sequence<T> getTools() {
        return this.tools;
    }

    protected Sequence<T> getDefaultTools() {
        return this.defaultTools;
    }

    private Details createTool(InfoTool tool) {
        LinkkiText caption = new LinkkiText(tool.getCaption(), null);
        Details details = new Details((Component)caption, tool.getComponent());
        details.setWidthFull();
        details.setId(tool.getId());
        details.addThemeVariants((ThemeVariant[])new DetailsVariant[]{DetailsVariant.FILLED});
        details.addOpenedChangeListener(this::onOpenedChange);
        return details;
    }

    protected void onOpenedChange(Details.OpenedChangeEvent event) {
        if (event.isFromClient()) {
            this.updateUrlParameters();
            this.uiUpdated();
        }
    }

    private void updateUrlParameters() {
        List<String> openToolIds = this.getOpenedTools().map(Component::getId).flatMap(Optional::stream).toList();
        if (openToolIds.isEmpty()) {
            openToolIds = List.of(NO_TOOL_OPEN);
        }
        this.updateUrlParameters(openToolIds);
    }

    protected void updateUrlParameters(List<String> openedTools) {
    }

    public void uiUpdated() {
        this.tools.forEach(this::updateToolUi);
    }

    private void updateToolUi(InfoTool tool) {
        tool.getUpdateUiHandler().apply();
        this.findToolDetailsById(tool.getId()).ifPresent(t -> {
            t.getClassNames().clear();
            tool.getStyleNames().forEach(arg_0 -> ((Details)t).addClassName(arg_0));
        });
    }

    public void afterNavigation(AfterNavigationEvent event) {
        this.openToolsFromUrl(this.getOpenToolsIdsFromUrl(event.getLocation()));
    }

    protected List<String> getOpenToolsIdsFromUrl(Location location) {
        Map parameters = location.getQueryParameters().getParameters();
        return parameters.getOrDefault(QUERY_PARAM, List.of());
    }

    void openToolsFromUrl(List<String> openToolsIdsFromUrl) {
        List<String> openToolsIds = openToolsIdsFromUrl.isEmpty() ? this.defaultTools.stream().map(InfoTool::getId).toList() : openToolsIdsFromUrl;
        openToolsIds.stream().map(this::findToolDetailsById).flatMap(Optional::stream).forEach(d -> d.setOpened(true));
    }

    private Optional<Details> findToolDetailsById(String id) {
        return this.getAllToolDetails().filter(c -> c.getId().orElse("noId").equals(id)).findFirst();
    }

    protected Stream<Details> getOpenedTools() {
        return this.getAllToolDetails().filter(Details::isOpened);
    }

    protected Stream<Details> getAllToolDetails() {
        return this.getChildren().filter(Details.class::isInstance).map(Details.class::cast);
    }
}

