/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.framework.ui.dialogs;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.dialog.DialogVariant;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H4;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.dom.ClassList;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.router.BeforeLeaveEvent;
import com.vaadin.flow.router.BeforeLeaveObserver;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.linkki.core.binding.validation.ValidationDisplayState;
import org.linkki.core.binding.validation.ValidationService;
import org.linkki.core.binding.validation.message.MessageList;
import org.linkki.core.binding.validation.message.Severity;
import org.linkki.core.ui.ComponentStyles;
import org.linkki.framework.ui.component.MessageUiComponents;
import org.linkki.framework.ui.nls.NlsText;
import org.linkki.util.handler.Handler;

@CssImport(value="./styles/linkki-dialog.css")
public class OkCancelDialog
extends Composite<Dialog>
implements HasSize,
BeforeLeaveObserver {
    public static final String CLASS_NAME_CONTENT_AREA = "linkki-dialog-content-area";
    public static final String CLASS_NAME_MESSAGE_AREA = "linkki-dialog-message-area";
    public static final String CLASS_NAME_DIALOG_LAYOUT = "linkki-dialog-layout";
    public static final String OK_BUTTON_ID = "okButton";
    public static final String CANCEL_BUTTON_ID = "cancelButton";
    private static final long serialVersionUID = 1L;
    private final VerticalLayout layout;
    private final VerticalLayout contentArea;
    private final Div messageArea;
    private final HorizontalLayout buttonArea;
    private final Button okButton;
    private final Handler okHandler;
    @CheckForNull
    private final Button cancelButton;
    private final Handler cancelHandler;
    private ValidationService validationService = ValidationService.NOP_VALIDATION_SERVICE;
    private ValidationDisplayState validationDisplayState = ValidationDisplayState.HIDE_MANDATORY_FIELD_VALIDATIONS;
    private Handler beforeOkHandler = Handler.NOP_HANDLER;
    private boolean okPressed = false;
    private boolean cancelPressed = false;
    private boolean mayProceed = true;
    private final H4 title;

    protected OkCancelDialog(String caption, Handler okHandler, Handler cancelHandler, ButtonOption buttonOption, Component ... contentComponents) {
        this.okHandler = Objects.requireNonNull(okHandler, "okHandler must not be null");
        this.cancelHandler = Objects.requireNonNull(cancelHandler, "cancelHandler must not be null");
        this.layout = new VerticalLayout();
        this.contentArea = new VerticalLayout();
        this.buttonArea = new HorizontalLayout();
        this.okButton = new Button(NlsText.getString("OkCancelDialog.OkButtonCaption"));
        this.cancelButton = buttonOption == ButtonOption.OK_CANCEL ? new Button(NlsText.getString("OkCancelDialog.CancelButtonCaption")) : null;
        ((Dialog)this.getContent()).setModal(true);
        ((Dialog)this.getContent()).setCloseOnOutsideClick(false);
        ((Dialog)this.getContent()).setResizable(false);
        ((Dialog)this.getContent()).setDraggable(true);
        ((Dialog)this.getContent()).addThemeVariants((ThemeVariant[])new DialogVariant[]{DialogVariant.LUMO_NO_PADDING});
        ((Dialog)this.getContent()).setMaxWidth("100%");
        ((Dialog)this.getContent()).setMaxHeight("100%");
        this.layout.setSizeFull();
        this.layout.setMargin(false);
        this.layout.setPadding(false);
        this.layout.setSpacing(false);
        this.layout.addClassName(CLASS_NAME_DIALOG_LAYOUT);
        ((Dialog)this.getContent()).add(new Component[]{this.layout});
        this.title = new H4(caption);
        this.title.addClassName("linkki-dialog-caption");
        ((Dialog)this.getContent()).getHeader().add(new Component[]{this.title});
        this.layout.add(new Component[]{this.contentArea});
        this.layout.setFlexGrow(1.0, new HasElement[]{this.contentArea});
        this.messageArea = new Div();
        this.messageArea.setWidthFull();
        this.messageArea.setClassName(CLASS_NAME_MESSAGE_AREA);
        this.messageArea.setVisible(false);
        this.layout.add(new Component[]{this.messageArea});
        this.buttonArea.setPadding(false);
        this.buttonArea.setSpacing(true);
        this.buttonArea.setWidthFull();
        this.buttonArea.addClassName("linkki-dialog-button-bar");
        this.buttonArea.setAlignItems(FlexComponent.Alignment.CENTER);
        this.buttonArea.setJustifyContentMode(FlexComponent.JustifyContentMode.END);
        this.buttonArea.getElement().getStyle().set("flexWrap", "wrap");
        ((Dialog)this.getContent()).getFooter().add(new Component[]{this.buttonArea});
        this.initContentArea(contentComponents);
        this.initButtons();
        this.initCloseListener();
    }

    private void initContentArea(Component ... contentComponents) {
        this.contentArea.addClassName(CLASS_NAME_CONTENT_AREA);
        this.contentArea.setPadding(false);
        this.contentArea.setSpacing(true);
        this.contentArea.setSizeFull();
        ComponentStyles.setOverflowAuto((Component)this.contentArea);
        for (Component contentComponent : contentComponents) {
            this.contentArea.add(new Component[]{contentComponent});
        }
    }

    private void initButtons() {
        this.buttonArea.add(new Component[]{this.okButton});
        this.okButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        this.okButton.setId(OK_BUTTON_ID);
        this.okButton.setDisableOnClick(true);
        this.okButton.addClickListener((ComponentEventListener & Serializable)e -> {
            if (((Dialog)this.getContent()).isOpened()) {
                this.setOkPressed();
                this.beforeOkHandler.andThen(() -> {
                    if (this.mayProceed) {
                        this.ok();
                        ((Dialog)this.getContent()).close();
                    }
                }).apply();
            }
        });
        this.okButton.addClickShortcut(Key.ENTER, new KeyModifier[0]);
        if (this.cancelButton != null) {
            this.buttonArea.add(new Component[]{this.cancelButton});
            this.cancelButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY_INLINE});
            this.cancelButton.setId(CANCEL_BUTTON_ID);
            this.cancelButton.addClickListener((ComponentEventListener & Serializable)e -> {
                if (((Dialog)this.getContent()).isOpened()) {
                    this.setCancelPressed(true);
                    this.close();
                }
            });
        }
    }

    private void initCloseListener() {
        ((Dialog)this.getContent()).addDialogCloseActionListener((ComponentEventListener & Serializable)e -> this.close());
    }

    public void setSize(String width, String height) {
        if (width != null) {
            ((Dialog)this.getContent()).setWidth(width);
        }
        if (height != null) {
            ((Dialog)this.getContent()).setHeight(height);
        }
        this.layout.setSizeFull();
        this.contentArea.setSizeFull();
    }

    public MessageList validate() {
        MessageList messages = this.validationDisplayState.filter(this.getValidationService().getValidationMessages());
        this.updateMessageArea(messages);
        this.mayProceed = !messages.containsErrorMsg();
        this.okButton.setEnabled(this.mayProceed);
        return messages;
    }

    private void updateMessageArea(MessageList messages) {
        this.messageArea.removeAll();
        this.messageArea.removeClassNames(new String[]{Severity.INFO.name(), Severity.WARNING.name(), Severity.ERROR.name()});
        messages.getMessageWithHighestSeverity().ifPresent(message -> {
            Component messageLabel = MessageUiComponents.createMessageComponent(message);
            this.messageArea.addClassName(message.getSeverity().name());
            this.messageArea.add(new Component[]{messageLabel});
        });
        this.messageArea.setVisible(this.messageArea.getComponentCount() > 0);
    }

    public ValidationService getValidationService() {
        return this.validationService;
    }

    public void setValidationService(ValidationService validationService) {
        this.validationService = Objects.requireNonNull(validationService, "validationService must not be null");
    }

    public void setBeforeOkHandler(Handler beforeOkHandler) {
        this.beforeOkHandler = beforeOkHandler;
    }

    public void addContent(Component c) {
        this.contentArea.add(new Component[]{c});
    }

    public void addContent(Component c, float expandRatio) {
        this.contentArea.add(new Component[]{c});
        this.contentArea.setFlexGrow((double)expandRatio, new HasElement[]{c});
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public ValidationDisplayState getValidationDisplayState() {
        return this.validationDisplayState;
    }

    private void setOkPressed() {
        this.okPressed = true;
        this.validationDisplayState = ValidationDisplayState.SHOW_ALL;
    }

    public boolean isCancelPressed() {
        return this.cancelPressed;
    }

    private void setCancelPressed(boolean cancelPressed) {
        this.cancelPressed = cancelPressed;
    }

    public String getCaption() {
        return this.title.getText();
    }

    public String getOkCaption() {
        return this.okButton.getText();
    }

    public void setOkCaption(String okCaption) {
        this.okButton.setText(Objects.requireNonNull(okCaption, "okCaption must not be null"));
    }

    public String getCancelCaption() {
        if (this.cancelButton != null) {
            return this.cancelButton.getText();
        }
        throw new IllegalStateException("Dialog does not have a cancel button");
    }

    public void setCancelCaption(String cancelCaption) {
        if (this.cancelButton == null) {
            throw new IllegalStateException("Dialog does not have a cancel button");
        }
        this.cancelButton.setText(Objects.requireNonNull(cancelCaption, "cancelCaption must not be null"));
    }

    protected void ok() {
        this.okHandler.apply();
    }

    protected void cancel() {
        this.cancelHandler.apply();
    }

    public OkCancelDialog open() {
        ((Dialog)this.getContent()).open();
        return this;
    }

    public void beforeLeave(BeforeLeaveEvent event) {
        ((Dialog)this.getContent()).close();
    }

    public void close() {
        this.cancelHandler.apply();
        ((Dialog)this.getContent()).close();
    }

    protected VerticalLayout getContentArea() {
        return this.contentArea;
    }

    protected Div getMessageArea() {
        return this.messageArea;
    }

    protected HorizontalLayout getButtonArea() {
        return this.buttonArea;
    }

    public Style getStyle() {
        return this.layout.getStyle();
    }

    public void setClassName(String className) {
        this.layout.setClassName(className);
    }

    public String getClassName() {
        return this.layout.getClassName();
    }

    public ClassList getClassNames() {
        return this.layout.getClassNames();
    }

    public void setWidth(String width) {
        ((Dialog)this.getContent()).setWidth(width);
    }

    public String getWidth() {
        return ((Dialog)this.getContent()).getWidth();
    }

    public void setMinWidth(String minWidth) {
        ((Dialog)this.getContent()).setMinWidth(minWidth);
    }

    public String getMinWidth() {
        return ((Dialog)this.getContent()).getMinWidth();
    }

    public void setMaxWidth(String maxWidth) {
        ((Dialog)this.getContent()).setMaxWidth(maxWidth);
    }

    public String getMaxWidth() {
        return ((Dialog)this.getContent()).getMaxWidth();
    }

    public void setHeight(String height) {
        ((Dialog)this.getContent()).setHeight(height);
    }

    public String getHeight() {
        return ((Dialog)this.getContent()).getHeight();
    }

    public void setMinHeight(String minHeight) {
        ((Dialog)this.getContent()).setMinHeight(minHeight);
    }

    public String getMinHeight() {
        return ((Dialog)this.getContent()).getMinHeight();
    }

    public void setMaxHeight(String maxHeight) {
        ((Dialog)this.getContent()).setMaxHeight(maxHeight);
    }

    public String getMaxHeight() {
        return ((Dialog)this.getContent()).getMaxHeight();
    }

    public static Builder builder(String caption) {
        return new Builder(caption);
    }

    public static enum ButtonOption {
        OK_ONLY,
        OK_CANCEL;

    }

    public static class Builder {
        private final String caption;
        private Component[] contentComponents = new Component[0];
        private Handler okHandler = Handler.NOP_HANDLER;
        private Handler cancelHandler = Handler.NOP_HANDLER;
        private ButtonOption buttonOption = ButtonOption.OK_CANCEL;
        @CheckForNull
        private String width;
        @CheckForNull
        private String height;
        @CheckForNull
        private String okCaption;
        @CheckForNull
        private String cancelCaption;

        Builder(String caption) {
            this.caption = Objects.requireNonNull(caption, "caption must not be null");
        }

        public Builder content(Component ... contentComponents) {
            this.contentComponents = Objects.requireNonNull(contentComponents, "content must not be null");
            return this;
        }

        public Builder okHandler(Handler okHandler) {
            this.okHandler = Objects.requireNonNull(okHandler, "okHandler must not be null");
            return this;
        }

        public Builder cancelHandler(Handler cancelHandler) {
            this.cancelHandler = Objects.requireNonNull(cancelHandler, "cancelHandler must not be null");
            return this;
        }

        public Builder buttonOption(ButtonOption buttonOption) {
            this.buttonOption = Objects.requireNonNull(buttonOption, "buttonOption must not be null");
            return this;
        }

        public Builder size(String width, String height) {
            this.width = Objects.requireNonNull(width, "width must not be null");
            this.height = Objects.requireNonNull(height, "height must not be null");
            return this;
        }

        public Builder okCaption(String okCaption) {
            this.okCaption = Objects.requireNonNull(okCaption, "okCaption must not be null");
            return this;
        }

        public Builder cancelCaption(String cancelCaption) {
            this.cancelCaption = Objects.requireNonNull(cancelCaption, "cancelCaption must not be null");
            return this;
        }

        public OkCancelDialog build() {
            OkCancelDialog createdDialog = new OkCancelDialog(this.caption, this.okHandler, this.cancelHandler, this.buttonOption, this.contentComponents);
            if (StringUtils.isNotBlank((CharSequence)this.width) && StringUtils.isNotBlank((CharSequence)this.height)) {
                createdDialog.setSize(this.width, this.height);
            }
            if (this.okCaption != null) {
                createdDialog.setOkCaption(this.okCaption);
            }
            if (this.cancelCaption != null && this.buttonOption == ButtonOption.OK_CANCEL) {
                createdDialog.setCancelCaption(this.cancelCaption);
            }
            return createdDialog;
        }
    }
}

