/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.framework.ui.dialogs;

import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.util.function.Function;
import org.linkki.core.binding.LinkkiBindingException;
import org.linkki.core.binding.descriptor.aspect.Aspect;
import org.linkki.core.binding.descriptor.aspect.LinkkiAspectDefinition;
import org.linkki.core.binding.descriptor.aspect.annotation.AspectDefinitionCreator;
import org.linkki.core.binding.descriptor.aspect.annotation.LinkkiAspect;
import org.linkki.core.binding.descriptor.aspect.base.CompositeAspectDefinition;
import org.linkki.core.binding.descriptor.property.annotation.BoundPropertyCreator;
import org.linkki.core.binding.descriptor.property.annotation.LinkkiBoundProperty;
import org.linkki.core.binding.dispatcher.PropertyDispatcher;
import org.linkki.core.binding.dispatcher.behavior.PropertyBehaviorProvider;
import org.linkki.core.binding.uicreation.LinkkiComponent;
import org.linkki.core.binding.uicreation.LinkkiComponentDefinition;
import org.linkki.core.binding.wrapper.ComponentWrapper;
import org.linkki.core.defaults.ui.aspects.types.CaptionType;
import org.linkki.core.ui.aspects.CaptionAspectDefinition;
import org.linkki.core.ui.aspects.LabelAspectDefinition;
import org.linkki.core.uicreation.ComponentDefinitionCreator;
import org.linkki.core.uicreation.LinkkiPositioned;
import org.linkki.framework.ui.dialogs.DialogPmo;
import org.linkki.framework.ui.dialogs.OkCancelDialog;
import org.linkki.framework.ui.dialogs.PmoBasedDialogFactory;
import org.linkki.util.Objects;
import org.linkki.util.handler.Handler;

@LinkkiAspect(value=DialogButtonAspectDefinitionCreator.class)
@LinkkiComponent(value=DialogButtonComponentDefinitionCreator.class)
@LinkkiBoundProperty(value=BoundPropertyCreator.SimpleMemberNameBoundPropertyCreator.class)
@LinkkiPositioned
@Target(value={ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface UIOpenDialogButton {
    @LinkkiPositioned.Position
    public int position();

    public String label() default "";

    public String caption() default "derived.by.linkki";

    public CaptionType captionType() default CaptionType.STATIC;

    public static class OpenDialogButtonAspectDefinition
    implements LinkkiAspectDefinition {
        public void initModelUpdate(PropertyDispatcher propertyDispatcher, ComponentWrapper componentWrapper, Handler modelChanged) {
            Button button = (Button)componentWrapper.getComponent();
            button.addClickListener((ComponentEventListener & Serializable)e -> {
                Object aspectValue = propertyDispatcher.pull(Aspect.of((String)""));
                Objects.requireNonNull((Object)aspectValue, (String)"Aspect method must not return null");
                if (aspectValue instanceof DialogPmo) {
                    DialogPmo dialogPmo = (DialogPmo)aspectValue;
                    Handler okHandler = dialogPmo.getOkHandler().andThen(modelChanged);
                    new PmoBasedDialogFactory(dialogPmo::validate, PropertyBehaviorProvider.NO_BEHAVIOR_PROVIDER, dialogPmo.getPropertyDispatcherFactory()).openOkCancelDialog(dialogPmo.getCaption(), okHandler, dialogPmo.getContentPmo());
                } else {
                    try {
                        Function dialogCreator = (Function)aspectValue;
                        ((OkCancelDialog)((Object)((Object)dialogCreator.apply(modelChanged)))).open();
                    }
                    catch (ClassCastException exception) {
                        throw new LinkkiBindingException("Aspect method must either return a DialogPmo or a Function<Handler, OkCancelDialog>", (Exception)exception);
                    }
                }
            });
        }

        public Handler createUiUpdater(PropertyDispatcher propertyDispatcher, ComponentWrapper componentWrapper) {
            return Handler.NOP_HANDLER;
        }
    }

    public static class DialogButtonAspectDefinitionCreator
    implements AspectDefinitionCreator<UIOpenDialogButton> {
        public LinkkiAspectDefinition create(UIOpenDialogButton annotation) {
            return new CompositeAspectDefinition(new LinkkiAspectDefinition[]{new OpenDialogButtonAspectDefinition(), new CaptionAspectDefinition(annotation.captionType(), annotation.caption()), new LabelAspectDefinition(annotation.label())});
        }
    }

    public static class DialogButtonComponentDefinitionCreator
    implements ComponentDefinitionCreator<UIOpenDialogButton> {
        public LinkkiComponentDefinition create(UIOpenDialogButton annotation, AnnotatedElement annotatedElement) {
            return pmo -> new Button(annotation.caption());
        }
    }
}

