/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.framework.ui.error;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H4;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.ErrorParameter;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.internal.DefaultErrorHandler;
import com.vaadin.flow.server.HttpStatusCode;
import com.vaadin.flow.server.VaadinService;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.linkki.core.nls.NlsService;
import org.linkki.core.vaadin.component.base.LinkkiText;
import org.linkki.framework.ui.error.MessageException;
import org.linkki.framework.ui.nls.NlsText;

@CssImport(value="./styles/error-page.css")
@DefaultErrorHandler
public class LinkkiErrorPage
extends VerticalLayout
implements HasErrorParameter<Exception>,
HasDynamicTitle {
    private static final long serialVersionUID = 1L;
    private static final String BUNDLE_NAME = "org/linkki/framework/ui/nls/messages";
    private static final String MSG_KEY_GO_TO_START_VIEW = "ErrorPage.GoToStartView";
    private static final String MSG_KEY_PAGE_TITLE = "ErrorPage.Title";
    private static final String MSG_KEY_TAB_NAME = "ErrorPage.Tab.Name";
    private static final String MSG_KEY_DEFAULT_ERROR_MESSAGE = "ErrorPage.Default.Message";
    private static final Logger LOGGER = Logger.getLogger(LinkkiErrorPage.class.getName());
    private final Div messageWrapper;
    private String exceptionId;

    public LinkkiErrorPage() {
        this.setId(((Object)((Object)this)).getClass().getSimpleName());
        Div contentWrapper = this.createContentWrapper();
        this.messageWrapper = new Div();
        this.messageWrapper.setWidthFull();
        this.messageWrapper.addClassName("error-page-message");
        contentWrapper.add(new Component[]{this.messageWrapper});
    }

    public String getPageTitle() {
        return NlsText.getString(MSG_KEY_TAB_NAME);
    }

    public int setErrorParameter(BeforeEnterEvent event, ErrorParameter<Exception> parameter) {
        this.exceptionId = UUID.randomUUID().toString();
        this.logException(parameter);
        this.messageWrapper.removeAll();
        H4 title = new H4(NlsText.getString(MSG_KEY_PAGE_TITLE));
        this.messageWrapper.add(new Component[]{title});
        this.messageWrapper.add(new Component[]{this.createErrorMessage(parameter)});
        this.messageWrapper.add(new Component[]{this.createErrorDetails(parameter)});
        if (this.isDevelopmentMode()) {
            this.messageWrapper.add(new Component[]{this.createStackTrace(parameter.getException())});
        }
        this.messageWrapper.add(new Component[]{this.createNavigationButton()});
        return HttpStatusCode.INTERNAL_SERVER_ERROR.getCode();
    }

    protected void logException(ErrorParameter<Exception> parameter) {
        Exception exception = parameter.getCaughtException();
        if (exception instanceof MessageException) {
            if (exception.getCause() != null) {
                LOGGER.log(Level.SEVERE, "Unhandled exception [%s]".formatted(this.exceptionId), exception.getCause());
            }
        } else {
            LOGGER.log(Level.SEVERE, "Unhandled exception [%s]".formatted(this.exceptionId), exception);
        }
    }

    protected Component createErrorMessage(ErrorParameter<? extends Exception> parameter) {
        LinkkiText message = new LinkkiText();
        Exception exception = parameter.getCaughtException();
        if (exception instanceof MessageException) {
            message.setText(exception.getMessage());
        } else if (this.isDevelopmentMode()) {
            if (parameter.hasCustomMessage()) {
                message.setText(parameter.getCustomMessage());
            } else {
                message.setText(exception.getMessage());
            }
        } else {
            message.setText(NlsText.getString(MSG_KEY_DEFAULT_ERROR_MESSAGE));
        }
        return message;
    }

    protected Component createErrorDetails(ErrorParameter<Exception> parameter) {
        String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        LinkkiText component = new LinkkiText();
        component.setText("Timestamp: " + timestamp + " [" + this.exceptionId + "]");
        return component;
    }

    protected Button createNavigationButton() {
        Button goToStartViewButton = new Button(this.localize());
        goToStartViewButton.addClickListener((ComponentEventListener & Serializable)e -> UI.getCurrent().navigate(""));
        return goToStartViewButton;
    }

    protected Div getMessageWrapper() {
        return this.messageWrapper;
    }

    protected boolean isDevelopmentMode() {
        return !VaadinService.getCurrent().getDeploymentConfiguration().isProductionMode();
    }

    private String localize() {
        return NlsService.get().getString(BUNDLE_NAME, MSG_KEY_GO_TO_START_VIEW).orElse("!ErrorPage.GoToStartView!");
    }

    private Div createStackTrace(Exception exception) {
        StringWriter sw = new StringWriter();
        exception.printStackTrace(new PrintWriter(sw));
        String stackTrace = sw.toString();
        Div stackTraceDiv = new Div();
        stackTraceDiv.setText(stackTrace);
        stackTraceDiv.addClassName("error-page-stacktrace");
        return stackTraceDiv;
    }

    private Div createContentWrapper() {
        this.setDefaultHorizontalComponentAlignment(FlexComponent.Alignment.CENTER);
        this.addClassName("error-page");
        Div wrapper = new Div();
        this.add(new Component[]{wrapper});
        Div iconWrapper = new Div();
        iconWrapper.addClassName("error-page-icon");
        iconWrapper.addClassName("linkki-message-error");
        wrapper.add(new Component[]{iconWrapper});
        Icon icon = VaadinIcon.EXCLAMATION_CIRCLE.create();
        iconWrapper.add(new Component[]{icon});
        return wrapper;
    }
}

