/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.framework.ui.notifications;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H3;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import java.io.Serializable;
import org.linkki.core.binding.validation.message.MessageList;
import org.linkki.core.binding.validation.message.Severity;
import org.linkki.core.util.HtmlSanitizer;
import org.linkki.core.vaadin.component.base.LinkkiText;
import org.linkki.framework.ui.nls.NlsText;

@CssImport(value="./styles/linkki-notification.css")
public class NotificationUtil {
    public static final String LINKKI_NOTIFICATION_INFO = "info";
    public static final String LINKKI_NOTIFICATION_WARNING = "warning";
    public static final String LINKKI_NOTIFICATION_ERROR = "error";
    public static final int DEFAULT_DURATION_INFO = 3000;
    public static final int DEFAULT_DURATION_WARNING = 6000;
    private static int infoDuration = 3000;
    private static int warningDuration = 6000;

    private NotificationUtil() {
    }

    public static void setInfoDuration(int duration) {
        infoDuration = duration;
    }

    public static void setWarningDuration(int duration) {
        warningDuration = duration;
    }

    public static Notification show(String title, MessageList messages) {
        if (!messages.isEmpty()) {
            Severity severity = (Severity)messages.getSeverity().orElseThrow();
            Notification notification = NotificationUtil.createNotification(severity, title, NotificationUtil.createMessageListComponent(messages));
            notification.open();
            return notification;
        }
        Notification notification = NotificationUtil.createNotification(Severity.INFO, title, new Component[0]);
        notification.open();
        return notification;
    }

    public static Notification showInfo(String title, String description) {
        Notification notification = NotificationUtil.createNotification(Severity.INFO, title, new Component[]{NotificationUtil.createContent(description)});
        notification.open();
        return notification;
    }

    public static Notification showWarning(String title, String description) {
        Notification notification = NotificationUtil.createNotification(Severity.WARNING, title, new Component[]{NotificationUtil.createContent(description)});
        notification.open();
        return notification;
    }

    public static Notification showError(String title, String description) {
        Notification notification = NotificationUtil.createNotification(Severity.ERROR, title, new Component[]{NotificationUtil.createContent(description)});
        notification.open();
        return notification;
    }

    public static Notification createNotification(Severity severity, String title, Component ... components) {
        Div content = new Div();
        content.addClassName("linkki-notification-content");
        content.add(new Component[]{new H3(title)});
        content.add(components);
        Notification notification = new Notification(new Component[]{content});
        if (severity == Severity.INFO) {
            NotificationUtil.prepareNotification(notification, infoDuration, LINKKI_NOTIFICATION_INFO);
        } else if (severity == Severity.WARNING) {
            NotificationUtil.prepareNotification(notification, warningDuration, LINKKI_NOTIFICATION_WARNING);
        } else if (severity == Severity.ERROR) {
            NotificationUtil.prepareNotification(notification, 0, LINKKI_NOTIFICATION_ERROR);
        }
        return notification;
    }

    private static void prepareNotification(Notification notification, int duration, String themeName) {
        notification.setDuration(duration);
        notification.addThemeName(themeName);
        notification.setPosition(Notification.Position.TOP_CENTER);
        Button closeButton = new Button(NlsText.getString("NotificationUtil.CloseButtonCaption"), (ComponentEventListener & Serializable)e -> notification.close());
        notification.add(new Component[]{closeButton});
    }

    private static Div createContent(String description) {
        Div content = new Div();
        content.getElement().setProperty("innerHTML", HtmlSanitizer.sanitizeText((String)description));
        return content;
    }

    private static Component createMessageListComponent(MessageList messages) {
        VerticalLayout component = new VerticalLayout();
        component.setClassName("linkki-notification-messagelist");
        component.setPadding(false);
        messages.forEach(m -> {
            LinkkiText m2 = new LinkkiText();
            m2.setText(HtmlSanitizer.sanitizeText((String)m.getText()), true);
            if (m.getSeverity() == Severity.INFO) {
                m2.setIcon(VaadinIcon.INFO_CIRCLE);
            } else if (m.getSeverity() == Severity.WARNING) {
                m2.setIcon(VaadinIcon.WARNING);
            } else if (m.getSeverity() == Severity.ERROR) {
                m2.setIcon(VaadinIcon.CLOSE_CIRCLE);
            }
            component.add(new Component[]{m2});
        });
        return component;
    }
}

