/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.search;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.linkki.search.model.SearchController;
import org.linkki.search.pmo.SearchInputPmo;
import org.linkki.search.pmo.SearchLayoutPmo;
import org.linkki.search.pmo.SearchResultPmo;
import org.linkki.search.pmo.SearchResultTablePmo;

public class SearchLayoutBuilder<PARAM, RESULT, MODEL_OBJECT, ROW> {
    @CheckForNull
    private String caption;
    @CheckForNull
    private Function<Supplier<PARAM>, Object> parametersPmo;
    @CheckForNull
    private Function<MODEL_OBJECT, ROW> resultRowPmo;
    @CheckForNull
    private Function<ROW, MODEL_OBJECT> rowToResult;
    @CheckForNull
    private Class<? extends ROW> rowType;
    @CheckForNull
    private SearchController<PARAM, RESULT> searchController;
    @CheckForNull
    private Consumer<MODEL_OBJECT> primaryAction;
    @CheckForNull
    private Function<RESULT, List<? extends MODEL_OBJECT>> toResultList;
    private Optional<Integer> maxResult = Optional.empty();
    private Optional<Integer> pageSize = Optional.empty();

    public static <PARAM, RESULT, MODELOBJECT, ROW> SearchLayoutBuilder<PARAM, RESULT, MODELOBJECT, ROW> with() {
        return new SearchLayoutBuilder();
    }

    public SearchLayoutBuilder<PARAM, RESULT, MODEL_OBJECT, ROW> caption(String caption) {
        this.caption = caption;
        return this;
    }

    public SearchLayoutBuilder<PARAM, RESULT, MODEL_OBJECT, ROW> searchParametersPmo(Function<Supplier<PARAM>, Object> criteriaPmo) {
        this.parametersPmo = criteriaPmo;
        return this;
    }

    public SearchLayoutBuilder<PARAM, RESULT, MODEL_OBJECT, ROW> searchResultRowPmo(Function<MODEL_OBJECT, ROW> resultRowPmo, Function<ROW, MODEL_OBJECT> rowToResult, Class<? extends ROW> rowType) {
        this.resultRowPmo = resultRowPmo;
        this.rowToResult = rowToResult;
        this.rowType = rowType;
        return this;
    }

    public SearchLayoutBuilder<PARAM, RESULT, MODEL_OBJECT, ROW> searchController(SearchController<PARAM, RESULT> searchController, Function<RESULT, List<? extends MODEL_OBJECT>> toResultList) {
        this.searchController = searchController;
        this.toResultList = toResultList;
        return this;
    }

    public SearchLayoutBuilder<PARAM, RESULT, MODEL_OBJECT, ROW> primaryAction(Consumer<MODEL_OBJECT> primaryAction) {
        this.primaryAction = primaryAction;
        return this;
    }

    public SearchLayoutBuilder<PARAM, RESULT, MODEL_OBJECT, ROW> maxResult(int maxResult) {
        this.maxResult = Optional.of(maxResult);
        return this;
    }

    public SearchLayoutBuilder<PARAM, RESULT, MODEL_OBJECT, ROW> pageSize(int pageSize) {
        this.pageSize = Optional.of(pageSize);
        return this;
    }

    public SearchLayoutPmo<ROW> build() {
        Function<Supplier<PARAM>, Object> parametersPmoChecked = Objects.requireNonNull(this.parametersPmo, "parametersPmo must not be null");
        Function<MODEL_OBJECT, ROW> resultRowPmoChecked = Objects.requireNonNull(this.resultRowPmo, "resultRowPmo must not be null");
        Function<ROW, MODEL_OBJECT> rowToResultChecked = Objects.requireNonNull(this.rowToResult, "rowToResult must not be null");
        Class<? extends ROW> rowTypeChecked = Objects.requireNonNull(this.rowType, "rowType must not be null");
        SearchController<PARAM, RESULT> searchControllerChecked = Objects.requireNonNull(this.searchController, "searchController must not be null");
        Consumer<MODEL_OBJECT> primaryActionChecked = Objects.requireNonNull(this.primaryAction, "primaryAction must not be null");
        Function<RESULT, List<? extends MODEL_OBJECT>> toResultListChecked = Objects.requireNonNull(this.toResultList, "toResultList must not be null");
        return new SearchLayoutPmo<ROW>(Optional.ofNullable(this.caption), this.createSearchInputPmo(parametersPmoChecked, searchControllerChecked), this.createSearchResultPmo(resultRowPmoChecked, rowTypeChecked, rowToResultChecked, primaryActionChecked, searchControllerChecked, toResultListChecked));
    }

    private SearchInputPmo createSearchInputPmo(Function<Supplier<PARAM>, Object> parametersPmo, SearchController<PARAM, RESULT> searchController) {
        return new SearchInputPmo(parametersPmo.apply(searchController::getParameters), searchController::search, searchController::reset);
    }

    private SearchResultPmo<MODEL_OBJECT, ROW> createSearchResultPmo(Function<MODEL_OBJECT, ROW> resultRowPmo, Class<? extends ROW> rowType, Function<ROW, MODEL_OBJECT> rowToResult, Consumer<MODEL_OBJECT> primaryAction, SearchController<PARAM, RESULT> searchController, Function<RESULT, List<? extends MODEL_OBJECT>> toResultList) {
        SearchResultTablePmo searchResultTablePmo = new SearchResultTablePmo(() -> this.getLimitedResult(searchController, toResultList), resultRowPmo, rowType, r -> primaryAction.accept(rowToResult.apply(r)), this.pageSize);
        return new SearchResultPmo(searchResultTablePmo, () -> this.getResult(searchController, toResultList), searchController::getMessages, this.maxResult);
    }

    private List<? extends MODEL_OBJECT> getResult(SearchController<PARAM, RESULT> searchController, Function<RESULT, List<? extends MODEL_OBJECT>> toResultList) {
        return ((Optional)searchController.get()).map(toResultList).orElse(Collections.emptyList());
    }

    private List<? extends MODEL_OBJECT> getLimitedResult(SearchController<PARAM, RESULT> searchController, Function<RESULT, List<? extends MODEL_OBJECT>> toResultList) {
        List<MODEL_OBJECT> results = this.getResult(searchController, toResultList);
        if (this.maxResult.isPresent() && results.size() > this.maxResult.get()) {
            return results.subList(0, this.maxResult.get());
        }
        return results;
    }
}

