/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.search.model;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.QueryParameters;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.linkki.core.binding.validation.message.Message;
import org.linkki.core.binding.validation.message.MessageList;
import org.linkki.search.model.SearchController;
import org.linkki.search.model.SearchParameterMapper;
import org.linkki.search.util.ParamsUtil;

public class RoutingSearchController<PARAM, RESULT>
implements SearchController<PARAM, RESULT> {
    private static final String SUBMIT_PARAMETER = "submit";
    private final String viewPath;
    private final SearchParameterMapper<PARAM> parameterMapper;
    private final Function<PARAM, RESULT> searchFunction;
    private PARAM parameters;
    private final Function<RESULT, MessageList> messages;
    @CheckForNull
    private RESULT result;

    public RoutingSearchController(String viewPath, Function<PARAM, RESULT> searchFunction, SearchParameterMapper<PARAM> parameterMapper, Function<RESULT, MessageList> messages) {
        this.viewPath = viewPath;
        this.searchFunction = searchFunction;
        this.parameterMapper = parameterMapper;
        this.parameters = parameterMapper.toSearchParameters(Collections.emptyMap());
        this.messages = messages;
    }

    public static void navigateTo(String path, Map<String, List<String>> queryParams) {
        Map<String, List<String>> params = ParamsUtil.removeEmptyValues(queryParams);
        params.put(SUBMIT_PARAMETER, List.of("true"));
        UI.getCurrent().navigate(path, new QueryParameters(params));
    }

    public void initialize(Location newLocation) {
        Map<String, List<String>> queryParams = newLocation.getQueryParameters().getParameters();
        if ((queryParams = ParamsUtil.removeEmptyValues(queryParams)).containsKey(SUBMIT_PARAMETER)) {
            queryParams.remove(SUBMIT_PARAMETER);
            this.parameters = this.parameterMapper.toSearchParameters(queryParams);
            this.result = this.searchFunction.apply(this.parameters);
        } else {
            this.parameters = this.parameterMapper.toSearchParameters(queryParams);
            this.result = null;
        }
    }

    @Override
    public Optional<RESULT> get() {
        return Optional.ofNullable(this.result);
    }

    @Override
    public void search() {
        RoutingSearchController.navigateTo(this.viewPath, this.parameterMapper.toQueryParameters(this.parameters));
    }

    @Override
    public MessageList getMessages() {
        return ((Optional)this.get()).map(this.messages).orElse(new MessageList(new Message[0]));
    }

    @Override
    public void reset() {
        UI.getCurrent().navigate(this.viewPath, QueryParameters.empty());
    }

    @Override
    public PARAM getParameters() {
        return this.parameters;
    }
}

