/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.search.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.linkki.core.binding.validation.message.Message;
import org.linkki.core.binding.validation.message.MessageList;
import org.linkki.search.model.SearchController;

public class SimpleSearchController<PARAM, RESULT>
implements SearchController<PARAM, RESULT> {
    private final Supplier<PARAM> parameterCreator;
    private final Function<PARAM, RESULT> searchFunction;
    private final Function<RESULT, MessageList> messages;
    private PARAM parameters;
    @CheckForNull
    private RESULT result;

    public SimpleSearchController(Supplier<PARAM> parameterCreator, Function<PARAM, RESULT> searchFunction, Function<RESULT, MessageList> messages) {
        this.parameterCreator = parameterCreator;
        this.searchFunction = searchFunction;
        this.messages = messages;
        this.parameters = parameterCreator.get();
    }

    @Override
    public Optional<RESULT> get() {
        return Optional.ofNullable(this.result);
    }

    @Override
    public void search() {
        this.result = this.searchFunction.apply(this.parameters);
    }

    @Override
    public MessageList getMessages() {
        return ((Optional)this.get()).map(this.messages).orElse(new MessageList(new Message[0]));
    }

    @Override
    public void reset() {
        this.result = null;
        this.parameters = this.parameterCreator.get();
    }

    @Override
    public PARAM getParameters() {
        return this.parameters;
    }
}

