/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.search.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ParamsUtil {
    private ParamsUtil() {
    }

    public static Map<String, List<String>> expand(Map<String, String> params) {
        LinkedHashMap<String, List<String>> expandedMap = new LinkedHashMap<String, List<String>>();
        params.forEach((key, value) -> expandedMap.put((String)key, Collections.singletonList(value)));
        return expandedMap;
    }

    public static Map<String, String> flatten(Map<String, List<String>> params) {
        LinkedHashMap<String, String> flattenedMap = new LinkedHashMap<String, String>();
        params.forEach((key, values) -> flattenedMap.put((String)key, (String)values.get(0)));
        return flattenedMap;
    }

    public static Map<String, List<String>> removeEmptyValues(Map<String, List<String>> params) {
        LinkedHashMap<String, List<String>> sanitizedMap = new LinkedHashMap<String, List<String>>();
        params.forEach((key, values) -> {
            if (values != null) {
                ArrayList sanitizedValues = new ArrayList(values);
                sanitizedValues.removeAll(Arrays.asList(null, ""));
                if (!sanitizedValues.isEmpty()) {
                    sanitizedMap.put((String)key, sanitizedValues);
                }
            }
        });
        return sanitizedMap;
    }

    public static Optional<LocalDate> parseIsoDate(@CheckForNull String value) {
        if (value != null) {
            try {
                return Optional.of(LocalDate.parse(value, DateTimeFormatter.ISO_DATE));
            }
            catch (DateTimeParseException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @CheckForNull
    public static String formatIsoDate(@CheckForNull LocalDate value) {
        if (value != null) {
            try {
                return value.format(DateTimeFormatter.ISO_DATE);
            }
            catch (DateTimeParseException e) {
                return null;
            }
        }
        return null;
    }

    public static Optional<Boolean> parseBoolean(@CheckForNull String value) {
        return Optional.ofNullable(value).map(Boolean::valueOf);
    }

    @CheckForNull
    public static String formatBoolean(@CheckForNull Boolean value) {
        return value != null ? String.valueOf(value) : null;
    }
}

