/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public final class DateFormats {
    public static final String PATTERN_ISO = "yyyy-MM-dd";
    public static final String PATTERN_EN = "MM/dd/yyyy";
    public static final String PATTERN_DE = "dd.MM.yyyy";
    public static final String PATTERN_EN_US = "MM/dd/yyyy";
    public static final String PATTERN_EN_GB = "dd/MM/yyyy";
    private static final Map<String, String> LANGUAGE_PATTERNS = new HashMap<String, String>();
    private static final Map<Locale, String> LOCALE_PATTERNS = new HashMap<Locale, String>();

    private DateFormats() {
    }

    public static void register(String languageCode, String pattern) {
        LANGUAGE_PATTERNS.put(languageCode, pattern);
    }

    public static void register(Locale locale, String pattern) {
        LOCALE_PATTERNS.put(locale, pattern);
    }

    public static String getPattern(Locale locale) {
        Objects.requireNonNull(locale, "locale must not be null");
        if (LOCALE_PATTERNS.containsKey(locale)) {
            return LOCALE_PATTERNS.get(locale);
        }
        if (LANGUAGE_PATTERNS.containsKey(locale.getLanguage())) {
            return LANGUAGE_PATTERNS.get(locale.getLanguage());
        }
        return DateFormats.defaultLocalePattern(locale);
    }

    private static String defaultLocalePattern(Locale locale) {
        Objects.requireNonNull(locale, "locale must not be null");
        DateFormat dateFormat = DateFormat.getDateInstance(3, locale);
        if (dateFormat instanceof SimpleDateFormat) {
            String pattern = ((SimpleDateFormat)dateFormat).toPattern();
            return "y-MM-dd".equals(pattern) ? PATTERN_ISO : pattern;
        }
        return PATTERN_ISO;
    }

    static {
        LANGUAGE_PATTERNS.put(Locale.ENGLISH.getLanguage(), "MM/dd/yyyy");
        LANGUAGE_PATTERNS.put(Locale.GERMAN.getLanguage(), PATTERN_DE);
        LOCALE_PATTERNS.put(Locale.US, "MM/dd/yyyy");
        LOCALE_PATTERNS.put(Locale.UK, PATTERN_EN_GB);
    }
}

