/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.util.reflection;

import java.lang.reflect.InvocationTargetException;
import java.util.function.Supplier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;

public class Classes {
    private Classes() {
    }

    public static <T> Class<? extends T> getType(Supplier<Class<? extends T>> typeSupplier, Class<? extends T> aptFallback) {
        try {
            return typeSupplier.get();
        }
        catch (MirroredTypeException e) {
            return aptFallback;
        }
    }

    public static String getTypeName(Supplier<? extends Class<?>> classSupplier) {
        try {
            return classSupplier.get().getName();
        }
        catch (MirroredTypeException mte) {
            DeclaredType typeMirror = (DeclaredType)mte.getTypeMirror();
            TypeElement typeElement = (TypeElement)typeMirror.asElement();
            return typeElement.getQualifiedName().toString();
        }
    }

    public static <T> T instantiate(Supplier<Class<? extends T>> classSupplier, Class<? extends T> aptFallback) {
        return Classes.instantiate(Classes.getType(classSupplier, aptFallback));
    }

    public static <T> T instantiate(Class<T> clazz) {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException(String.format("Cannot instantiate %s", clazz.getName()), e);
        }
    }
}

