/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.util.reflection.accessor;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaConversionException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.linkki.util.reflection.accessor.AbstractMethod;

final class WriteMethod<T, V>
extends AbstractMethod<T, BiConsumer<T, V>> {
    WriteMethod(Class<? extends T> boundClass, String propertyName, Supplier<Optional<Method>> methodSupplier) {
        super(boundClass, propertyName, methodSupplier);
    }

    public void writeValue(T target, @CheckForNull V value) {
        ((BiConsumer)this.getMethodAsFunction()).accept(target, value);
    }

    @Override
    protected BiConsumer<T, V> fallbackReflectionCall(Method method) {
        return (o, v) -> {
            try {
                method.invoke(o, v);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw this.errorCallingMethod(e).get();
            }
        };
    }

    @Override
    protected CallSite getCallSiteForFunction(MethodHandles.Lookup lookup, MethodHandle methodHandle) throws LambdaConversionException {
        return LambdaMetafactory.metafactory(lookup, "accept", MethodType.methodType(BiConsumer.class), MethodType.methodType(Void.TYPE, Object.class, Object.class), methodHandle, this.wrap(methodHandle));
    }

    @Override
    protected BiConsumer<T, V> handleExceptionForMethodHandle(BiConsumer<T, V> methodAsFunction) {
        return (o, v) -> {
            try {
                methodAsFunction.accept(o, v);
            }
            catch (RuntimeException e) {
                throw this.errorCallingMethod(e).get();
            }
        };
    }

    public String toString() {
        return "write method for " + this.getBoundClass().getName() + "#" + this.getPropertyName();
    }
}

