/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.util.reflection.accessor;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaConversionException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.linkki.util.ExceptionSupplier;
import org.linkki.util.Objects;
import org.linkki.util.reflection.LookupProvider;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class AbstractMethod<T, I> {
    private static final Logger LOGGER = Logger.getLogger(AbstractMethod.class.getName());
    private static boolean reflectionWarning = true;
    private final Class<? extends T> boundClass;
    private final String propertyName;
    private final Supplier<Optional<Method>> methodSupplier;
    @CheckForNull
    private I methodAsFunction;

    AbstractMethod(Class<? extends T> boundClass, String propertyName, Supplier<Optional<Method>> methodSupplier) {
        this.boundClass = Objects.requireNonNull(boundClass, "boundClass must not be null");
        this.propertyName = Objects.requireNonNull(propertyName, "propertyName must not be null");
        this.methodSupplier = Objects.requireNonNull(methodSupplier, "methodSupplier must not be null");
    }

    public boolean isPresent() {
        return this.getReflectionMethod().isPresent();
    }

    private Optional<Method> getReflectionMethod() {
        return this.methodSupplier.get();
    }

    protected Class<? extends T> getBoundClass() {
        return this.boundClass;
    }

    protected String getPropertyName() {
        return this.propertyName;
    }

    protected Method getMethodWithExceptionHandling() {
        return this.getReflectionMethod().orElseThrow(ExceptionSupplier.illegalStateException("Found no " + this));
    }

    protected Supplier<IllegalStateException> errorCallingMethod(Throwable cause) {
        return ExceptionSupplier.illegalStateException("Error calling " + this, cause);
    }

    public I getMethodAsFunction() {
        if (this.methodAsFunction == null) {
            Method method = this.getMethodWithExceptionHandling();
            MethodHandles.Lookup lookup = LookupProvider.lookup(method.getDeclaringClass());
            MethodHandle methodHandle = AbstractMethod.getMethodHandle(method, lookup);
            try {
                CallSite callSite = this.getCallSiteForFunction(lookup, methodHandle);
                I function = this.invokeCallSiteForFunction(callSite, method);
                this.methodAsFunction = this.handleExceptionForMethodHandle(function);
            }
            catch (LambdaConversionException e) {
                AbstractMethod.logFallbackToReflection(e);
                this.methodAsFunction = this.fallbackReflectionCall(method);
            }
        }
        return this.methodAsFunction;
    }

    protected abstract I handleExceptionForMethodHandle(I var1);

    private I invokeCallSiteForFunction(CallSite callSite, Method method) {
        try {
            return (I)callSite.getTarget().invoke();
        }
        catch (Throwable e) {
            throw new IllegalStateException("Can't create function for " + method, e);
        }
    }

    private static MethodHandle getMethodHandle(Method method, MethodHandles.Lookup lookup) {
        try {
            return lookup.unreflect(method);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Can't get " + MethodHandle.class.getSimpleName() + " for " + method, e);
        }
    }

    protected MethodType wrap(MethodHandle methodHandle) {
        return methodHandle.type().wrap().changeReturnType(Void.TYPE);
    }

    protected abstract CallSite getCallSiteForFunction(MethodHandles.Lookup var1, MethodHandle var2) throws LambdaConversionException;

    private static void logFallbackToReflection(LambdaConversionException exception) {
        if (reflectionWarning) {
            LOGGER.warning(() -> "Error during method invocation using method handle, falling back to reflection API. This is probably due to different class loaders in play, e.g. when using Spring Devtools. This should not happen in production. Configure a fine logging level for more information.\n");
            reflectionWarning = false;
        }
        LOGGER.fine(() -> "Cannot call method using method handle: " + exception.getMessage());
    }

    protected abstract I fallbackReflectionCall(Method var1);
}

