/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.vaadin.component.menu;

import com.vaadin.flow.component.icon.VaadinIcon;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.linkki.util.Objects;
import org.linkki.util.handler.Handler;

public class MenuItemDefinition {
    public static final Pattern PATTERN_UNKNOWN_CHARS = Pattern.compile("[^a-z0-9]");
    public static final Pattern PATTERN_WHITESPACES = Pattern.compile("\\s+");
    private final String caption;
    @CheckForNull
    private final VaadinIcon icon;
    private final Handler command;
    private final String id;
    private final boolean visible;
    private final boolean enabled;

    public MenuItemDefinition(String caption, @CheckForNull VaadinIcon icon, Handler command) {
        this(caption, icon, command, MenuItemDefinition.captionToId(caption));
    }

    public MenuItemDefinition(String caption, @CheckForNull VaadinIcon icon, Handler command, String id) {
        this(id, caption, icon, command, true, true);
    }

    private MenuItemDefinition(String id, String caption, @CheckForNull VaadinIcon icon, Handler command, boolean visible, boolean enabled) {
        this.caption = caption;
        this.icon = icon;
        this.command = command;
        this.id = id;
        this.visible = visible;
        this.enabled = enabled;
    }

    public String getCaption() {
        return this.caption;
    }

    @CheckForNull
    public VaadinIcon getIcon() {
        return this.icon;
    }

    public Handler getCommand() {
        return this.command;
    }

    public String getId() {
        return this.id;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private static String captionToId(String caption) {
        String id = PATTERN_WHITESPACES.matcher(PATTERN_UNKNOWN_CHARS.matcher(caption.toLowerCase()).replaceAll(" ")).replaceAll("-");
        id = StringUtils.removeEnd((String)id, (String)"-");
        return id;
    }

    public static Builder builder(String id) {
        return new Builder((String)Objects.requireNonNull((Object)id, (String)"id must not be null"));
    }

    public static class Builder {
        private final String id;
        private String caption = "";
        @CheckForNull
        private VaadinIcon icon = null;
        private Handler command = Handler.NOP_HANDLER;
        private boolean visible = true;
        private boolean enabled = true;

        private Builder(String id) {
            this.id = id;
        }

        public Builder caption(String caption) {
            this.caption = (String)Objects.requireNonNull((Object)caption, (String)"caption must not be null");
            return this;
        }

        public Builder icon(@CheckForNull VaadinIcon icon) {
            this.icon = icon;
            return this;
        }

        public Builder command(Handler command) {
            this.command = (Handler)Objects.requireNonNull((Object)command, (String)"command must not be null");
            return this;
        }

        public Builder visibleIf(boolean visible) {
            this.visible = visible;
            return this;
        }

        public Builder enabledIf(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public MenuItemDefinition build() {
            return new MenuItemDefinition(this.id, this.caption, this.icon, this.command, this.visible, this.enabled);
        }
    }
}

