/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.vaadin.component.menu;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.contextmenu.SubMenu;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.menubar.MenuBar;
import com.vaadin.flow.component.menubar.MenuBarVariant;
import com.vaadin.flow.component.shared.ThemeVariant;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.linkki.core.vaadin.component.HasCaption;
import org.linkki.core.vaadin.component.HasIcon;
import org.linkki.core.vaadin.component.menu.MenuItemDefinition;
import org.linkki.util.handler.Handler;

public class SingleItemMenuBar
extends Composite<MenuBar>
implements HasCaption,
HasEnabled,
HasIcon {
    private static final long serialVersionUID = 1L;
    private final MenuItem theItem;
    @CheckForNull
    private VaadinIcon icon;

    public SingleItemMenuBar(String caption) {
        this(caption, null);
    }

    public SingleItemMenuBar(String caption, @CheckForNull VaadinIcon icon) {
        this(caption, icon, new MenuBarVariant[0]);
    }

    public SingleItemMenuBar(String caption, @CheckForNull VaadinIcon icon, MenuBarVariant[] variants) {
        this.theItem = ((MenuBar)this.getContent()).addItem(caption);
        this.icon = icon;
        if (icon != null) {
            this.theItem.addComponentAsFirst((Component)icon.create());
        }
        ((MenuBar)this.getContent()).addThemeVariants((ThemeVariant[])variants);
    }

    public void setId(String id) {
        super.setId(id);
        this.theItem.setId(id);
    }

    public List<MenuItem> getItems() {
        return Collections.singletonList(this.theItem);
    }

    @Override
    public String getCaption() {
        return this.theItem.getText();
    }

    @Override
    public void setCaption(String caption) {
        this.updateContent(caption, this.icon);
    }

    @Override
    @CheckForNull
    public VaadinIcon getIcon() {
        return this.icon;
    }

    @Override
    public void setIcon(@CheckForNull VaadinIcon icon) {
        this.updateContent(this.getCaption(), icon);
    }

    private void updateContent(String caption, @CheckForNull VaadinIcon newIcon) {
        this.icon = newIcon;
        this.theItem.removeAll();
        if (this.icon != null) {
            this.theItem.add(new Component[]{this.icon.create(), new Text(caption)});
        } else {
            this.theItem.add(caption);
        }
    }

    public void createSubMenuItems(List<MenuItemDefinition> itemDefinitions, Handler modelChanged) {
        SubMenu subMenu = (SubMenu)this.theItem.getSubMenu();
        for (MenuItemDefinition itemDefinition : itemDefinitions) {
            MenuItem subMenuItem = (MenuItem)subMenu.addItem(itemDefinition.getCaption());
            subMenuItem.setId(this.getSubMenuItemId(itemDefinition));
            this.setSubMenuItemIcon(subMenuItem, itemDefinition);
            subMenuItem.setVisible(itemDefinition.isVisible());
            subMenuItem.setEnabled(itemDefinition.isEnabled());
            subMenuItem.addClickListener((ComponentEventListener & Serializable)event -> {
                if (subMenuItem.isVisible() && subMenuItem.isEnabled()) {
                    itemDefinition.getCommand().andThen(modelChanged).apply();
                }
            });
        }
    }

    private String getSubMenuItemId(MenuItemDefinition itemDefinition) {
        return this.theItem.getId().map(id -> id + "-" + itemDefinition.getId()).orElse(itemDefinition.getId());
    }

    private void setSubMenuItemIcon(MenuItem subMenuItem, MenuItemDefinition definition) {
        VaadinIcon subMenuIcon = definition.getIcon();
        if (subMenuIcon != null) {
            Icon iconComponent = subMenuIcon.create();
            iconComponent.setSize("1em");
            iconComponent.getElement().getStyle().set("margin-right", "0.5em");
            subMenuItem.addComponentAsFirst((Component)iconComponent);
        }
    }

    public void updateSubMenuItems(List<MenuItemDefinition> itemDefinitions) {
        Map itemDefinitionById = itemDefinitions.stream().collect(Collectors.toMap(this::getSubMenuItemId, Function.identity()));
        ((SubMenu)this.theItem.getSubMenu()).getItems().forEach(item -> item.getId().map(itemDefinitionById::get).ifPresent(itemDefinition -> {
            item.setVisible(itemDefinition.isVisible());
            item.setEnabled(itemDefinition.isEnabled());
        }));
    }
}

