/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.vaadin.component.tablayout;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HtmlComponent;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.component.tabs.Tabs;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.router.AfterNavigationEvent;
import com.vaadin.flow.router.AfterNavigationObserver;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.linkki.core.vaadin.component.tablayout.LinkkiTabSheet;

@Tag(value="linkki-tab-layout")
@JsModule(value="./src/linkki-tab-layout.ts")
@CssImport(value="./styles/linkki-tab-layout.css")
public class LinkkiTabLayout
extends HtmlComponent
implements AfterNavigationObserver {
    public static final String THEME_VARIANT_SOLID = "solid";
    static final String PROPERTY_ORIENTATION = "orientation";
    private static final long serialVersionUID = 1L;
    private final Tabs tabsComponent;
    private final Div contentWrapper;
    private final Map<Tab, LinkkiTabSheet> tabSheets = new LinkedHashMap<Tab, LinkkiTabSheet>();

    public LinkkiTabLayout() {
        this(Tabs.Orientation.HORIZONTAL);
    }

    public LinkkiTabLayout(Tabs.Orientation orientation) {
        this.tabsComponent = new Tabs();
        this.tabsComponent.setOrientation(orientation);
        this.tabsComponent.addSelectedChangeListener((ComponentEventListener & Serializable)e -> {
            Optional.ofNullable(e.getPreviousTab()).ifPresent(this::unselect);
            Optional.ofNullable(e.getSelectedTab()).ifPresent(t -> this.select((Tab)t, (Tabs.SelectedChangeEvent)e));
        });
        this.tabsComponent.getElement().setAttribute("slot", "tabs");
        this.contentWrapper = new Div();
        this.contentWrapper.getElement().setAttribute("slot", "content");
        this.getElement().setAttribute(PROPERTY_ORIENTATION, orientation.name().toLowerCase());
        this.getElement().appendChild(new Element[]{this.tabsComponent.getElement(), this.contentWrapper.getElement()});
        this.setSizeFull();
    }

    private void unselect(Tab tab) {
        this.tabSheets.get(tab).unselect();
    }

    private void select(Tab tab, Tabs.SelectedChangeEvent e) {
        this.tabSheets.get(tab).select((HasComponents)this.contentWrapper, e);
    }

    public void afterNavigation(AfterNavigationEvent event) {
        this.updateSheetVisibility();
    }

    public void updateSheetVisibility() {
        this.tabSheets.forEach((key, value) -> key.setVisible(value.isVisible()));
        this.updateSelectionAfterVisibleChange();
    }

    private void updateSelectionAfterVisibleChange() {
        Tab selectedTab = this.getTabsComponent().getSelectedTab();
        if (selectedTab != null && !this.tabSheets.get(selectedTab).isVisible()) {
            this.tabSheets.keySet().stream().filter(Component::isVisible).findFirst().ifPresentOrElse(tab -> this.getTabsComponent().setSelectedTab(tab), () -> this.getTabsComponent().setSelectedTab(null));
        }
    }

    public Registration addSelectedChangeListener(ComponentEventListener<Tabs.SelectedChangeEvent> listener) {
        return this.getTabsComponent().addSelectedChangeListener(listener);
    }

    public void addTabSheet(LinkkiTabSheet tabSheet, int index) {
        this.tabSheets.put(tabSheet.getTab(), tabSheet);
        this.getTabsComponent().addTabAtIndex(index, tabSheet.getTab());
    }

    public void addTabSheet(LinkkiTabSheet tabSheet) {
        this.addTabSheet(tabSheet, this.tabsComponent.getTabCount());
    }

    public void addTabSheets(Stream<LinkkiTabSheet> sheets) {
        sheets.forEach(this::addTabSheet);
    }

    public void addTabSheets(Iterable<LinkkiTabSheet> sheets) {
        sheets.forEach(this::addTabSheet);
    }

    public void addTabSheets(LinkkiTabSheet ... sheets) {
        this.addTabSheets(Arrays.stream(sheets));
    }

    public void removeTabSheet(LinkkiTabSheet tabSheet) {
        Tab tab = tabSheet.getTab();
        this.getTabsComponent().remove(new Tab[]{tab});
        if (tabSheet.isContentLoaded()) {
            this.contentWrapper.remove(new Component[]{this.tabSheets.get(tab).getContent()});
        }
        this.tabSheets.remove(tab);
    }

    public void removeAllTabSheets() {
        this.getTabsComponent().removeAll();
        this.tabSheets.values().forEach(tabSheet -> this.contentWrapper.removeAll());
        this.tabSheets.clear();
    }

    public void setSelectedIndex(int index) {
        this.getTabsComponent().setSelectedIndex(index);
    }

    public int getSelectedIndex() {
        return this.getTabsComponent().getSelectedIndex();
    }

    public void setSelectedTabSheet(String id) {
        this.getTabsComponent().setSelectedTab(this.getTabSheet(id).orElseThrow(() -> new IllegalArgumentException("None of the tab sheets has the id " + id)).getTab());
    }

    public LinkkiTabSheet getSelectedTabSheet() {
        return Optional.ofNullable(this.tabsComponent.getSelectedTab()).map(this.tabSheets::get).orElseThrow(() -> new NoSuchElementException("No selected tab"));
    }

    public Optional<LinkkiTabSheet> getTabSheet(String id) {
        return this.tabSheets.keySet().stream().filter(t -> ((String)t.getId().get()).equals(id)).findFirst().map(this.tabSheets::get);
    }

    public List<LinkkiTabSheet> getTabSheets() {
        return this.getTabsComponent().getChildren().filter(Tab.class::isInstance).map(this.tabSheets::get).collect(Collectors.toList());
    }

    public Tabs getTabsComponent() {
        return this.tabsComponent;
    }

    public Component getContent() {
        return this.contentWrapper;
    }

    public static LinkkiTabLayout newSidebarLayout() {
        LinkkiTabLayout sidebarLayout = new LinkkiTabLayout(Tabs.Orientation.VERTICAL);
        sidebarLayout.getElement().getThemeList().add((Object)THEME_VARIANT_SOLID);
        return sidebarLayout;
    }
}

