/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.test;

import com.github.mvysny.kaributesting.v10.GridKt;
import com.github.mvysny.kaributesting.v10.LocatorJ;
import com.github.mvysny.kaributesting.v10.NotificationsKt;
import com.github.mvysny.kaributesting.v10.PrettyPrintTree;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasText;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H3;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.dom.ThemeList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import org.awaitility.Awaitility;
import org.linkki.core.binding.validation.message.Severity;

public class KaribuUtils {
    public static final Logger LOGGER = Logger.getAnonymousLogger();

    private KaribuUtils() {
    }

    @Deprecated(since="2.6.0")
    public static Notification getNotification() {
        return Notifications.get();
    }

    @Deprecated(since="2.6.0")
    public static String getNotificationTitle(Notification notification) {
        return Notifications.getTitle(notification);
    }

    public static <T extends Component> T getRootComponent(Class<T> type) {
        List<Component> components = com.vaadin.flow.component.UI.getCurrent().getChildren().filter(c -> !(c instanceof Notification)).toList();
        if (components.isEmpty()) {
            throw new AssertionError((Object)"No components attached to UI");
        }
        if (components.size() == 1) {
            Component component = components.get(0);
            if (type.isInstance(component)) {
                return (T)((Component)type.cast(component));
            }
            throw new AssertionError((Object)("Root component is of type " + component.getClass().getName()));
        }
        throw new AssertionError((Object)("Multiple root components attached to UI: " + components));
    }

    public static <T extends Component> T getWithId(Class<T> componentClass, String id) {
        return (T)LocatorJ._get(componentClass, sp -> sp.withId(id));
    }

    public static <T extends Component> T getWithId(Component parent, Class<T> componentClass, String id) {
        return (T)LocatorJ._get((Component)parent, componentClass, sp -> sp.withId(id));
    }

    public static String printComponentTree() {
        return KaribuUtils.printComponentTree((Component)com.vaadin.flow.component.UI.getCurrent());
    }

    public static String printComponentTree(Component component) {
        String tree = PrettyPrintTree.Companion.ofVaadin(component).print();
        LOGGER.info(tree);
        return tree;
    }

    public static String getTextContent(Component component) {
        String string;
        if (component instanceof HasText) {
            HasText hasText = (HasText)component;
            string = hasText.getText();
        } else if (component instanceof HasValue) {
            HasValue hasValue = (HasValue)component;
            string = (String)hasValue.getValue();
        } else {
            string = component.getElement().getText();
        }
        return string;
    }

    public static class Notifications {
        private Notifications() {
        }

        public static Notification get() {
            List notifications = NotificationsKt.getNotifications();
            if (notifications.isEmpty()) {
                throw new AssertionError((Object)"No notifications are open");
            }
            if (notifications.size() == 1) {
                return (Notification)notifications.get(0);
            }
            throw new AssertionError((Object)"Multiple notifications are open");
        }

        public static String getTitle(Notification notification) {
            return Notifications.getTitleComponent(notification).getText();
        }

        public static String getDescription(Notification notification) {
            Div content = Notifications.getContent(notification);
            return ((Div)LocatorJ._get((Component)content, Div.class, ss -> ss.withPredicate(c -> c != content))).getElement().getProperty("innerHTML");
        }

        public static List<Component> getContentComponents(Notification notification) {
            return Notifications.getContent(notification).getChildren().filter(c -> c != Notifications.getTitleComponent(notification)).toList();
        }

        public static Severity getSeverity(Notification notification) {
            ThemeList themeNames = notification.getThemeNames();
            if (themeNames.contains((Object)Severity.ERROR.name().toLowerCase())) {
                return Severity.ERROR;
            }
            if (themeNames.contains((Object)Severity.WARNING.name().toLowerCase())) {
                return Severity.WARNING;
            }
            if (themeNames.contains((Object)Severity.INFO.name().toLowerCase())) {
                return Severity.INFO;
            }
            throw new AssertionError((Object)"No severity theme found on the notification. This is probably because the Notification is not created with NotificationUtil.");
        }

        private static Div getContent(Notification notification) {
            return (Div)LocatorJ._get((Component)notification, Div.class, ss -> ss.withClasses("linkki-notification-content"));
        }

        private static H3 getTitleComponent(Notification notification) {
            return (H3)LocatorJ._get((Component)Notifications.getContent(notification), H3.class);
        }
    }

    public static class Layouts {
        private Layouts() {
        }

        public static <T extends Component> T getWithPmo(Class<T> componentClass, Class<?> pmoClass) {
            return (T)LocatorJ._get(componentClass, sp -> sp.withId(pmoClass.getSimpleName()));
        }
    }

    public static class Grids {
        private Grids() {
        }

        public static <T> Grid<T> get(Component parent) {
            return (Grid)LocatorJ._get((Component)parent, Grid.class);
        }

        public static <T> Grid<T> getWithPmo(Class<?> pmoClass) {
            return (Grid)LocatorJ._get(Grid.class, sp -> sp.withId(pmoClass.getSimpleName() + "_table"));
        }

        public static <T> List<String> getTextContentsInColumn(Grid<T> grid, String columnKey) {
            return IntStream.range(0, grid.getListDataView().getItemCount()).mapToObj(i -> GridKt._getCellComponent((Grid)grid, (int)i, (String)columnKey).getElement().getTextRecursively()).toList();
        }
    }

    public static class Dialogs {
        private Dialogs() {
        }

        public static Button getOkButton(Composite<Dialog> dialog) {
            return Dialogs.getOkButton((Dialog)dialog.getContent());
        }

        public static void clickOkButton() {
            Dialogs.getOkButton((Dialog)LocatorJ._get(Dialog.class)).click();
        }

        public static Button getCancelButton(Composite<Dialog> dialog) {
            return Dialogs.getCancelButton((Dialog)dialog.getContent());
        }

        public static void clickCancelButton() {
            Dialogs.getCancelButton((Dialog)LocatorJ._get(Dialog.class)).click();
        }

        public static List<Component> getContents(Composite<Dialog> dialog) {
            return ((VerticalLayout)LocatorJ._get((Component)dialog.getContent(), VerticalLayout.class, ss -> ss.withClasses("linkki-dialog-content-area"))).getChildren().toList();
        }

        private static Button getOkButton(Dialog dialog) {
            return (Button)LocatorJ._get((Component)dialog, Button.class, ss -> ss.withId("okButton"));
        }

        private static Button getCancelButton(Dialog dialog) {
            return (Button)LocatorJ._get((Component)dialog, Button.class, ss -> ss.withId("cancelButton"));
        }
    }

    public static class ComboBoxes
    extends Fields {
        private ComboBoxes() {
        }

        public static <T> ComboBox<T> getComboBoxWithId(Component parent, String id) {
            return KaribuUtils.getWithId(parent, ComboBox.class, id);
        }

        public static <T> ComboBox<T> getComboBoxWithId(String id) {
            return KaribuUtils.getWithId(ComboBox.class, id);
        }

        public static <T> void setComboBoxValue(String id, T value) {
            ComboBoxes.setValue(ComboBox.class, id, value);
        }
    }

    public static class Fields {
        private Fields() {
        }

        public static <C extends AbstractField<C, T>, T> void setValue(C field, T value) {
            field.setValue(value);
            LocatorJ._fireValueChange(field, (boolean)true);
        }

        public static <C extends AbstractField<C, T>, T> void setValue(Class<C> clazz, String id, T value) {
            AbstractField component = (AbstractField)LocatorJ._get(clazz, ss -> ss.withId(id));
            Fields.setValue(component, value);
        }
    }

    public static class UI {
        private UI() {
        }

        public static void push() {
            UI.push(com.vaadin.flow.component.UI.getCurrent());
        }

        public static void push(com.vaadin.flow.component.UI ui) {
            Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> !ui.getSession().getPendingAccessQueue().isEmpty());
            ui.getSession().getService().runPendingAccessTasks(ui.getSession());
        }
    }
}

