/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.test;

import com.github.mvysny.kaributesting.v10.LocatorJ;
import com.github.mvysny.kaributesting.v10.PrettyPrintTreeKt;
import com.github.mvysny.kaributesting.v10.SearchSpec;
import com.github.mvysny.kaributesting.v10.SearchSpecJ;
import com.vaadin.flow.component.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import kotlin.ranges.IntRange;
import org.assertj.core.api.Condition;
import org.jetbrains.annotations.NotNull;
import org.linkki.core.ui.test.KaribuUtils;
import org.linkki.util.Consumers;

public class ComponentConditions {
    private ComponentConditions() {
    }

    public static Condition<Component> childOf(Component parent) {
        return new Condition(c -> ComponentConditions.isChildOf(c, parent), "a child of %s, but the parent has the component tree \n%s", new Object[]{PrettyPrintTreeKt.toPrettyString((Component)parent), KaribuUtils.getComponentTree(parent)});
    }

    private static boolean isChildOf(Component child, Component parent) {
        Optional childParent = child.getParent();
        if (childParent.isEmpty()) {
            return false;
        }
        if (((Component)childParent.get()).equals(parent)) {
            return true;
        }
        return ComponentConditions.isChildOf((Component)childParent.get(), parent);
    }

    public static Condition<Component> anyChildSatisfying(Predicate<Component> predicate, String description) {
        return new Condition(c -> ComponentConditions.isAnyChildSatisfying(c, predicate), "any child that " + description, new Object[0]);
    }

    private static boolean isAnyChildSatisfying(Component component, Predicate<Component> predicate) {
        if (component.getChildren().anyMatch(predicate)) {
            return true;
        }
        return component.getChildren().anyMatch(c -> ComponentConditions.isAnyChildSatisfying(c, predicate));
    }

    public static Condition<Component> exactlyOneVisibleChildOfType(Class<? extends Component> type) {
        return ComponentConditions.exactlyOneVisibleChildOfType(type, Consumers.nopConsumer());
    }

    public static <T extends Component> Condition<Component> exactlyOneVisibleChildOfType(Class<T> type, Consumer<SearchSpecJ<T>> searchSpec) {
        return new Condition(c -> ComponentConditions.findChildren(type, searchSpec, c).size() == 1, "exactly one visible child matching type %s", new Object[]{ComponentConditions.displaySearchSpec(type, searchSpec)});
    }

    @NotNull
    private static <T extends Component> List<T> findChildren(Class<T> type, Consumer<SearchSpecJ<T>> searchSpec, Component c) {
        return c.getChildren().map(child -> LocatorJ._find((Component)child, (Class)type, (Consumer)searchSpec)).flatMap(Collection::stream).toList();
    }

    public static <T extends Component> Condition<Component> anyVisibleChildOfType(Class<T> type) {
        return ComponentConditions.anyVisibleChildOfType(type, Consumers.nopConsumer());
    }

    public static <T extends Component> Condition<Component> anyVisibleChildOfType(Class<T> type, Consumer<SearchSpecJ<T>> searchSpec) {
        return new Condition(c -> !LocatorJ._find((Component)c, (Class)type, (Consumer)searchSpec).isEmpty(), "any visible child matching %s", new Object[]{ComponentConditions.displaySearchSpec(type, searchSpec)});
    }

    private static <T extends Component> String displaySearchSpec(Class<T> type, Consumer<SearchSpecJ<T>> searchSpecJConsumer) {
        SearchSpec<T> searchSpec = ComponentConditions.createSearchSpec(type);
        searchSpecJConsumer.accept(new SearchSpecJ(searchSpec));
        return searchSpec.toString();
    }

    private static <T extends Component> SearchSpec<T> createSearchSpec(Class<T> type) {
        return new SearchSpec(type, null, null, null, null, null, new IntRange(0, Integer.MAX_VALUE), null, null, null, null, null, null, null, new HashMap(), new ArrayList());
    }
}

